/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.parser.csv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.ParseException;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import net.morilib.parser.BeanIntrospection;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.CSVField;
import net.morilib.parser.csv.CSVFormat;
import net.morilib.parser.csv.CSVHandler;
import net.morilib.parser.csv.CSVParseException;
import net.morilib.parser.csv.CSVParserContinuation;
import net.morilib.parser.csv.CSVPullParser;
import net.morilib.parser.csv.CSVPushParser;
import net.morilib.parser.csv.SimpleCSVPushParser;

public final class BeanCSVPullParser<T>
implements CSVPullParser<T>,
Closeable {
    private static final CSVParserContinuation MARKER = new CSVParserContinuation(){};
    private final Hndl handler = new Hndl();
    private Class<T> klasse;
    private CSVPushParser parser;
    private CSVParserContinuation cont;
    private T toreturn;
    private SortedMap<Integer, Method> callmtd;
    private SortedMap<Integer, Format> format;
    private Reader stream;

    public BeanCSVPullParser(Reader rd, CSVConfig f, Class<T> klasse) {
        Method[] mth0;
        this.parser = new SimpleCSVPushParser(this.handler, f);
        this.callmtd = new TreeMap<Integer, Method>();
        this.stream = rd;
        Method[] methodArray = mth0 = klasse.getMethods();
        int n = mth0.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.isAnnotationPresent(CSVField.class)) {
                CSVField fn = m.getAnnotation(CSVField.class);
                this.callmtd.put(fn.value(), m);
                if (m.isAnnotationPresent(CSVFormat.class)) {
                    CSVFormat ff = m.getAnnotation(CSVFormat.class);
                    Class<?>[] kls = m.getParameterTypes();
                    if (kls.length != 1) {
                        throw new IllegalArgumentException("Illegal setter");
                    }
                    if (ff != null) {
                        this.format.put(fn.value(), BeanIntrospection.introspectFormat(kls[0], ff.value()));
                    } else {
                        this.format.put(fn.value(), null);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public T get() {
        return this.toreturn;
    }

    @Override
    public boolean next() throws CSVException, IOException {
        if (this.cont == null) {
            throw new NoSuchElementException();
        }
        if (this.cont == MARKER) {
            this.cont = this.parser.parse(this.stream);
        }
        if ((this.cont = this.parser.parse(this.cont)) == null) {
            this.stream.close();
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
            this.cont = null;
        }
    }

    private class Hndl
    implements CSVHandler {
        private Hndl() {
        }

        @Override
        public boolean startFile() throws CSVException {
            return false;
        }

        @Override
        public boolean endFile() throws CSVException {
            return false;
        }

        @Override
        public boolean startLine(int line) throws CSVException {
            try {
                BeanCSVPullParser.this.toreturn = BeanCSVPullParser.this.klasse.newInstance();
                return false;
            }
            catch (InstantiationException e) {
                throw new CSVException(e);
            }
            catch (IllegalAccessException e) {
                throw new CSVException(e);
            }
        }

        @Override
        public boolean endLine(int line) throws CSVException {
            return true;
        }

        @Override
        public boolean emptyLine(int line) throws CSVException {
            return false;
        }

        @Override
        public boolean element(String elm, int line, int field) throws CSVException {
            if (field > (Integer)BeanCSVPullParser.this.format.lastKey()) {
                return false;
            }
            if (BeanCSVPullParser.this.callmtd.get(field) == null) {
                return false;
            }
            try {
                BeanIntrospection.setFormattedProperty((Method)BeanCSVPullParser.this.callmtd.get(field), (Format)BeanCSVPullParser.this.format.get(field), elm, BeanCSVPullParser.this.toreturn);
                return false;
            }
            catch (ParseException e) {
                return false;
            }
        }

        @Override
        public boolean comment(String com, int line) throws CSVException {
            return false;
        }

        @Override
        public boolean error(CSVParseException e) throws CSVException {
            throw e;
        }
    }
}

