/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.phys.unit;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.phys.unit.Unit;
import net.morilib.phys.unit.UnitSystem;
import net.morilib.phys.unit.Units;

public final class Quantity
implements Serializable {
    public static final Quantity ZERO = new Quantity(0.0, Unit.NONDIMENSION);
    private static final Pattern PTN = Pattern.compile("(-?([0-9]+|[0-9]*\\.[0-9]+)?([eE]-?[0-9]+)?)(.*)");
    private double value;
    private Unit unit;

    public static Quantity parse(UnitSystem sys, String s) {
        Matcher m = PTN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String s1 = m.group(1);
        String s2 = m.group(4);
        if (s2.equals("")) {
            return new Quantity(Double.parseDouble(s1), Unit.NONDIMENSION);
        }
        Quantity q = Units.parse(sys, s2);
        if (q != null) {
            return q.multiply(Double.parseDouble(s1));
        }
        return null;
    }

    public Quantity(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    Quantity(String u) {
        this.value = 1.0;
        this.unit = Unit.getUnit(u, 1);
    }

    public double getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Quantity multiply(double x) {
        return new Quantity(this.value * x, this.unit);
    }

    public Quantity divide(double x) {
        return new Quantity(this.value / x, this.unit);
    }

    public Quantity add(Quantity q) {
        if (q == null) {
            throw new NullPointerException();
        }
        if (!this.unit.equals(q.unit)) {
            throw new ArithmeticException();
        }
        return new Quantity(this.value + q.value, this.unit);
    }

    public Quantity subtract(Quantity q) {
        if (q == null) {
            throw new NullPointerException();
        }
        if (!this.unit.equals(q.unit)) {
            throw new ArithmeticException();
        }
        return new Quantity(this.value - q.value, this.unit);
    }

    public Quantity multiply(Quantity q) {
        if (q == null) {
            throw new NullPointerException();
        }
        return new Quantity(this.value * q.value, this.unit.multiply(q.unit));
    }

    public Quantity divide(Quantity q) {
        if (q == null) {
            throw new NullPointerException();
        }
        if (q.value == 0.0) {
            throw new ArithmeticException();
        }
        return new Quantity(this.value / q.value, this.unit.divide(q.unit));
    }

    public Quantity pow(int n) {
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return this;
        }
        return new Quantity(Math.pow(this.value, n), this.unit.pow(n));
    }

    public int hashCode() {
        int r = 17;
        r = 37 * ((int)Double.doubleToLongBits(this.value) + r);
        r = 37 * (this.unit.hashCode() + r);
        return r;
    }

    public boolean equals(Object o) {
        return o instanceof Quantity && this.value == ((Quantity)o).value && this.unit.equals(((Quantity)o).unit);
    }

    public String toString() {
        return String.valueOf(this.value) + this.unit.toString();
    }
}

