/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.range.Intervals;
import net.morilib.range.Limit;
import net.morilib.range.MarkerEnum;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.range.Ranges;
import net.morilib.util.Section;
import net.morilib.util.Sets;

public final class Interval
extends Range
implements Comparable<Interval>,
Section<Object> {
    public static final SupremumMarker TO_SUPREMUM = new SupremumMarker("to supremum");
    public static final SupremumMarker BELOW_INFIMUM = new SupremumMarker("below infimum");
    public static final InfimumMarker FROM_INFIMUM = new InfimumMarker("from infimum");
    public static final InfimumMarker ABOVE_SUPREMUM = new InfimumMarker("above supremum");
    private Object sup;
    private Object inf;
    private int left;
    private int right;

    Interval(Object inf, Object sup, int l, int r) {
        if (Limit.compareBound(inf, sup) > 0) {
            throw new IllegalArgumentException();
        }
        this.inf = inf;
        this.sup = sup;
        this.left = l;
        this.right = r;
    }

    Interval(Object inf, boolean infOpen, Object sup, boolean supOpen) {
        this.inf = inf;
        this.sup = sup;
        this.left = infOpen ? 1 : 0;
        this.right = supOpen ? -1 : 0;
    }

    int compareInfimum(Object o, boolean open) {
        return Interval.compareInfimum(this, o, open);
    }

    int compareSupremum(Object o, boolean open) {
        return Interval.compareInfimum(o, open, this);
    }

    static void meet(Interval i, Range r, RangeAdder bld) {
        for (Interval t : r.intervals()) {
            bld.addInterval(i.meetInterval(t));
        }
    }

    static void limit(Interval i, Range r, RangeAdder bld) {
        for (Interval t : r.intervals()) {
            bld.addAll(i.complementIntervals(t));
        }
    }

    static int compareInfimum(Interval b1, Object o2, boolean b2) {
        int r = Limit.compareBound(b1.getInfimumBound(), o2);
        return r != 0 ? r : (b1.isInfimumOpen() && !b2 ? 1 : (b1.isInfimumClosed() && b2 ? -1 : 0));
    }

    static int compareInfimum(Object o1, boolean b1, Interval b2) {
        int r = Limit.compareBound(o1, b2.getSupremumBound());
        return r != 0 ? r : (b1 && b2.isSupremumClosed() ? 1 : (!b1 && b2.isSupremumOpen() ? -1 : 0));
    }

    public static Interval newInstance(Object inf, boolean infOpen, Object sup, boolean supOpen) {
        if (inf == null || sup == null) {
            throw new NullPointerException();
        }
        int c = Limit.compareBound(inf, sup);
        if (c > 0 || c == 0 && (infOpen || supOpen)) {
            throw new IllegalArgumentException();
        }
        return new Interval(inf, infOpen, sup, supOpen);
    }

    public static Interval newInstance(Interval dinf, Interval dsup) {
        return Interval.newInstance(dinf.getInfimumBound(), dinf.isInfimumOpen(), dsup.getSupremumBound(), dsup.isSupremumOpen());
    }

    public static Interval newPoint(Object o) {
        return new Interval(o, false, o, false);
    }

    public static boolean independentOf(Interval src, Interval dst) {
        return src.isInfimumAboveAllOf(dst) || src.isSupremumBelowAllOf(dst);
    }

    public static boolean interiorIndependentOf(Interval src, Interval dst) {
        return !src.isInfimumBelowAnyOf(dst) || !src.isSupremumAboveAnyOf(dst);
    }

    public static int compareInfimum(Interval t, Interval i) {
        boolean c4;
        if (t.isEmpty()) {
            return i.isEmpty() ? 0 : -1;
        }
        if (i.isEmpty()) {
            return 1;
        }
        if (!t.isInfimumFinite()) {
            return i.isInfimumFinite() ? -1 : 0;
        }
        if (!i.isInfimumFinite()) {
            return 1;
        }
        int c = t.isInfimumBoundAboveAnyClosureOf(i) ? 1 : (t.isInfimumBoundBelowAllClosureOf(i) ? -1 : 0);
        boolean c3 = t.isInfimumOpen() && i.isInfimumClosed();
        boolean bl = c4 = t.isInfimumClosed() && i.isInfimumOpen();
        return c != 0 ? c : (c3 ? 1 : (c4 ? -1 : 0));
    }

    public static int compareSupremum(Interval t, Interval i) {
        boolean d4;
        if (t.isEmpty()) {
            return i.isEmpty() ? 0 : -1;
        }
        if (i.isEmpty()) {
            return 1;
        }
        if (!t.isSupremumFinite()) {
            return i.isSupremumFinite() ? 1 : 0;
        }
        if (!i.isSupremumFinite()) {
            return -1;
        }
        int d = t.isSupremumBoundAboveAllClosureOf(i) ? 1 : (t.isSupremumBoundBelowAnyClosureOf(i) ? -1 : 0);
        boolean d3 = t.isSupremumOpen() && i.isSupremumClosed();
        boolean bl = d4 = t.isSupremumClosed() && i.isSupremumOpen();
        return d != 0 ? d : (d3 ? -1 : (d4 ? 1 : 0));
    }

    public static int compare(Interval t, Interval i) {
        int inf = Interval.compareInfimum(t, i);
        return inf != 0 ? inf : Interval.compareSupremum(t, i);
    }

    public Interval cloneInterval(Object inf, boolean infOpen, Object sup, boolean supOpen) {
        return Interval.newInstance(inf, infOpen, sup, supOpen);
    }

    public Interval cloneInterval() {
        return this.cloneInterval(this.getInfimumBound(), this.isInfimumOpen(), this.getSupremumBound(), this.isSupremumOpen());
    }

    public Interval cloneInterval(InfimumMarker dinf, Interval dsup) {
        boolean iOpn;
        Object rinf;
        if (dinf == FROM_INFIMUM) {
            rinf = this.getInfimumBound();
            iOpn = this.isInfimumOpen();
        } else if (dinf == ABOVE_SUPREMUM) {
            rinf = this.getSupremumBound();
            iOpn = !this.isSupremumOpen();
        } else {
            throw new IllegalArgumentException(dinf.toString());
        }
        Object rsup = dsup.getSupremumBound();
        boolean sOpn = dsup.isSupremumOpen();
        return this.cloneInterval(rinf, iOpn, rsup, sOpn);
    }

    public Interval cloneInterval(Interval dinf, SupremumMarker dsup) {
        boolean sOpn;
        Object rsup;
        Object rinf = dinf.getInfimumBound();
        boolean iOpn = dinf.isInfimumOpen();
        if (dsup == TO_SUPREMUM) {
            rsup = this.getSupremumBound();
            sOpn = this.isSupremumOpen();
        } else if (dsup == BELOW_INFIMUM) {
            rsup = this.getInfimumBound();
            sOpn = !this.isInfimumOpen();
        } else {
            throw new IllegalArgumentException(dsup.toString());
        }
        return this.cloneInterval(rinf, iOpn, rsup, sOpn);
    }

    @Override
    public Range closure() {
        return this.closureInterval();
    }

    @Override
    public Range interior() {
        return this.interiorInterval();
    }

    public Interval closureInterval() {
        return Intervals.newClosedInterval(this.inf, this.sup);
    }

    public Interval interiorInterval() {
        return Intervals.newOpenInterval(this.inf, this.sup);
    }

    public Interval coveredInterval(Interval iv) {
        if (this.containsAll(iv)) {
            return this;
        }
        if (this.in(iv)) {
            return iv;
        }
        if (iv.isInfimumAbove(this.getInfimumBound())) {
            return iv.cloneInterval(this, TO_SUPREMUM);
        }
        return iv.cloneInterval(FROM_INFIMUM, this);
    }

    public Interval hideUpperHalfIntervalOf(Interval iv) {
        if (iv.isInfimumAboveAllOf(this)) {
            return this;
        }
        if (!iv.isInfimumAboveAnyOf(this)) {
            return O;
        }
        return iv.cloneInterval(this, BELOW_INFIMUM);
    }

    public Interval hideLowerHalfIntervalOf(Interval iv) {
        if (iv.isSupremumBelowAllOf(this)) {
            return this;
        }
        if (!iv.isSupremumBelowAnyOf(this)) {
            return O;
        }
        return iv.cloneInterval(ABOVE_SUPREMUM, this);
    }

    public Interval lowerHalfInterval() {
        return Intervals.newInfimumlessInterval(this.getSupremumBound(), this.isSupremumOpen());
    }

    public Interval upperHalfInterval() {
        return Intervals.newSupremumlessInterval(this.getInfimumBound(), this.isInfimumOpen());
    }

    public Object getInfimumBound() {
        return this.inf;
    }

    public Object getSupremumBound() {
        return this.sup;
    }

    public Interval meetInterval(Interval j) {
        if (this.independentOf(j)) {
            return O;
        }
        if (this.isInfimumAboveAnyOf(j)) {
            return this.isSupremumAboveAllOf(j) ? Interval.newInstance(this, j) : this;
        }
        return this.isSupremumAboveAllOf(j) ? j : Interval.newInstance(j, this);
    }

    public SortedSet<Interval> complementIntervals(Interval u) {
        TreeSet<Interval> iv = new TreeSet<Interval>();
        if (this.independentOf(u)) {
            iv.add(this);
        } else {
            if (this.isInfimumBelowAllOf(u)) {
                iv.add(this.hideUpperHalfIntervalOf(u));
            }
            if (this.isSupremumAboveAllOf(u)) {
                iv.add(this.hideLowerHalfIntervalOf(u));
            }
        }
        return iv;
    }

    @Override
    boolean isInfimumBoundAbove(Object o) {
        return Limit.compareBound(o, this.getInfimumBound()) < 0;
    }

    @Override
    boolean isInfimumBoundBelow(Object o) {
        return Limit.compareBound(o, this.getInfimumBound()) > 0;
    }

    @Override
    boolean isInfimumBoundEqualTo(Object o) {
        return Limit.compareBound(o, this.getInfimumBound()) == 0;
    }

    @Override
    boolean isSupremumBoundAbove(Object o) {
        return Limit.compareBound(o, this.getSupremumBound()) < 0;
    }

    @Override
    boolean isSupremumBoundBelow(Object o) {
        return Limit.compareBound(o, this.getSupremumBound()) > 0;
    }

    @Override
    boolean isSupremumBoundEqualTo(Object o) {
        return Limit.compareBound(o, this.getSupremumBound()) == 0;
    }

    @Override
    boolean isInfimumAbove(Object o) {
        int r = Limit.compareBound(o, this.getInfimumBound());
        return r < 0 || r == 0 && this.isInfimumOpen();
    }

    @Override
    boolean isInfimumBelow(Object o) {
        return Limit.compareBound(o, this.getInfimumBound()) > 0;
    }

    @Override
    boolean isInfimumEqualTo(Object o) {
        return this.isInfimumClosed() && Limit.compareBound(o, this.getInfimumBound()) == 0;
    }

    @Override
    boolean isSupremumAbove(Object o) {
        return Limit.compareBound(o, this.getSupremumBound()) < 0;
    }

    @Override
    boolean isSupremumBelow(Object o) {
        int r = Limit.compareBound(o, this.getSupremumBound());
        return r > 0 || r == 0 && this.isSupremumOpen();
    }

    @Override
    boolean isSupremumEqualTo(Object o) {
        return !this.isSupremumOpen() && Limit.compareBound(o, this.getSupremumBound()) == 0;
    }

    @Override
    boolean isInfimumBoundBelowAllClosureOf(Range r) {
        return r.isInfimumBoundAbove(this.getInfimumBound());
    }

    @Override
    boolean isInfimumBoundAboveAllClosureOf(Range r) {
        return r.isSupremumBoundBelow(this.getInfimumBound());
    }

    @Override
    boolean isInfimumBoundBelowAnyClosureOf(Range r) {
        return r.isSupremumBoundAbove(this.getInfimumBound());
    }

    @Override
    boolean isInfimumBoundAboveAnyClosureOf(Range r) {
        return r.isInfimumBoundBelow(this.getInfimumBound());
    }

    @Override
    boolean contactInfimumBound(Range r) {
        return r.isSupremumBoundEqualTo(this.getInfimumBound());
    }

    @Override
    boolean commonInfimumBoundTo(Range r) {
        return r.isInfimumBoundEqualTo(this.getInfimumBound());
    }

    @Override
    boolean isSupremumBoundAboveAllClosureOf(Range r) {
        return r.isSupremumBoundBelow(this.getSupremumBound());
    }

    @Override
    boolean isSupremumBoundBelowAllClosureOf(Range r) {
        return r.isInfimumBoundAbove(this.getSupremumBound());
    }

    @Override
    boolean isSupremumBoundAboveAnyClosureOf(Range r) {
        return r.isInfimumBoundBelow(this.getSupremumBound());
    }

    @Override
    boolean isSupremumBoundBelowAnyClosureOf(Range r) {
        return r.isSupremumBoundAbove(this.getSupremumBound());
    }

    @Override
    boolean contactSupremumBound(Range r) {
        return r.isInfimumBoundEqualTo(this.getSupremumBound());
    }

    @Override
    boolean commonSupremumBoundTo(Range r) {
        return r.isSupremumBoundEqualTo(this.getSupremumBound());
    }

    @Override
    public boolean isInfimumFinite() {
        return this.getInfimumBound() != Limit.MINIMUM && this.getInfimumBound() != Limit.MAXIMUM;
    }

    @Override
    public boolean isSupremumFinite() {
        return this.getSupremumBound() != Limit.MINIMUM && this.getSupremumBound() != Limit.MAXIMUM;
    }

    @Override
    public boolean isInfimumOpen() {
        return !this.isInfimumFinite() || this.left != 0;
    }

    @Override
    public boolean isSupremumOpen() {
        return !this.isSupremumFinite() || this.right != 0;
    }

    @Override
    public boolean isInfimumClosed() {
        return !this.isInfimumFinite() || this.left == 0;
    }

    @Override
    public boolean isSupremumClosed() {
        return !this.isSupremumFinite() || this.right == 0;
    }

    @Override
    public boolean isOpen() {
        return this.isInfimumOpen() && this.isSupremumOpen();
    }

    @Override
    public boolean isClosed() {
        return this.isInfimumClosed() && this.isSupremumClosed();
    }

    @Override
    public boolean contains(Object o) {
        return !this.isInfimumAbove(o) && !this.isSupremumBelow(o);
    }

    @Override
    public boolean isNeighborhoodOf(Object o) {
        return this.isInfimumBoundBelow(o) && this.isSupremumBoundAbove(o);
    }

    @Override
    public boolean containsClosure(Object o) {
        return !this.isInfimumBoundAbove(o) && !this.isSupremumBoundBelow(o);
    }

    @Override
    public boolean containsBound(Object o) {
        return this.isInfimumBoundEqualTo(o) || this.isSupremumBoundEqualTo(o);
    }

    @Override
    public boolean closureContains(Range t) {
        Range r = t;
        return !this.isInfimumBoundAboveAnyClosureOf(r) && !this.isSupremumBoundBelowAnyClosureOf(r);
    }

    @Override
    public boolean interiorContains(Range t) {
        Range r = t;
        return this.isInfimumBelowAllOf(r) && this.isSupremumAboveAllOf(r);
    }

    @Override
    public boolean containsAll(Range t) {
        Range r = t;
        return !this.isInfimumAboveAnyOf(r) && !this.isSupremumBelowAnyOf(r);
    }

    @Override
    public boolean containsAny(Range t) {
        Range r = t;
        return !this.isInfimumAboveAllOf(r) && !this.isSupremumBelowAllOf(r);
    }

    @Override
    public SortedSet<Interval> intervals() {
        return Sets.sortedSingleton(this);
    }

    @Override
    public Range bound() {
        return Range.newPoints(this.boundElements());
    }

    @Override
    public SortedSet<?> boundElements() {
        if (this.isInfimumFinite() && this.isSupremumFinite()) {
            TreeSet<Object> s = new TreeSet<Object>();
            s.add(this.getInfimumBound());
            s.add(this.getSupremumBound());
            return s;
        }
        if (this.isInfimumFinite()) {
            return Sets.sortedSingleton(this.getInfimumBound());
        }
        if (this.isSupremumFinite()) {
            return Sets.sortedSingleton(this.getSupremumBound());
        }
        return Sets.emptySortedSet();
    }

    @Override
    public boolean infimumBoundIn(Range r) {
        return r.contains(this.getInfimumBound());
    }

    @Override
    public boolean supremumBoundIn(Range r) {
        return r.contains(this.getSupremumBound());
    }

    @Override
    public boolean boundsIn(Range t) {
        return t.contains(this.getInfimumBound()) && t.contains(this.getSupremumBound());
    }

    @Override
    public boolean boundsIndependentOf(Range t) {
        return !t.contains(this.getInfimumBound()) && !t.contains(this.getSupremumBound());
    }

    @Override
    public boolean in(Range t) {
        for (Interval j : t.intervals()) {
            if (!Ranges.inCoveredUpperHalfPlane(this, j) || !Ranges.inCoveredLowerHalfPlane(this, j)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean independentOf(Range t) {
        for (Interval j : t.intervals()) {
            if (Interval.independentOf(this, j)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean interiorIndependentOf(Range t) {
        for (Interval j : t.intervals()) {
            if (Interval.interiorIndependentOf(this, j)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getInfimumBound() == Limit.MAXIMUM && this.getSupremumBound() == Limit.MINIMUM;
    }

    @Override
    public int compareTo(Interval o) {
        if (o instanceof Interval) {
            return Interval.compare(this, o);
        }
        throw new ClassCastException();
    }

    @Override
    public boolean isFinite() {
        return this.sup.equals(this.inf) && this.left == this.right && this.left == 0;
    }

    @Override
    public SortedSet<?> getJavaSetIfFinite() {
        return this.isFinite() ? Sets.sortedSingleton(this.sup) : null;
    }

    @Override
    public int side(Object o) {
        if (this.isInfimumAbove(o)) {
            return -1;
        }
        if (this.isSupremumBelow(o)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int r = 17;
        r = 37 * r + this.inf.hashCode();
        r = 37 * r + this.sup.hashCode();
        r = 37 * r + this.left;
        r = 37 * r + this.right;
        return r;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getInfimumBound() == Limit.MAXIMUM) {
            return "Empty Interval";
        }
        buf.append(this.isInfimumOpen() ? "(" : "[");
        buf.append(this.inf == Limit.MINIMUM ? "-oo" : this.inf);
        buf.append(",");
        buf.append(this.sup == Limit.MAXIMUM ? "+oo" : this.sup);
        buf.append(this.isSupremumOpen() ? ")" : "]");
        return buf.toString();
    }

    static class InfimumMarker
    extends MarkerEnum {
        private InfimumMarker(String explain) {
            super(explain);
        }
    }

    static class SupremumMarker
    extends MarkerEnum {
        private SupremumMarker(String explain) {
            super(explain);
        }
    }
}

