/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range.integer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.range.IntervalsInt;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.range.integer.IntInterval;
import net.morilib.range.integer.IntMergedRange;
import net.morilib.range.integer.IntRange;

public abstract class AbstractIntRange
implements IntRange {
    public static IntRange makeRange(SortedSet<IntInterval> s) {
        switch (s.size()) {
            case 0: {
                return O;
            }
            case 1: {
                return s.first();
            }
        }
        return new IntMergedRange(s);
    }

    @Override
    public boolean isContained(IntRange r) {
        return r.containsAll(this);
    }

    @Override
    public boolean isOverlapped(IntRange r) {
        return r.containsAny(this);
    }

    @Override
    public IntRange join(IntRange r) {
        TreeSet<IntInterval> s = new TreeSet<IntInterval>();
        Iterator<IntInterval> i = this.intervals().iterator();
        Iterator<IntInterval> j = r.intervals().iterator();
        IntInterval t = null;
        if (this.cardinality() == 0L) {
            return r;
        }
        if (r.cardinality() == 0L) {
            return this;
        }
        IntInterval a = i.hasNext() ? i.next() : null;
        IntInterval b = j.hasNext() ? j.next() : null;
        while (a != null || b != null) {
            IntInterval c;
            if (b == null) {
                c = a;
                a = i.hasNext() ? i.next() : null;
            } else if (a == null) {
                c = b;
                b = j.hasNext() ? j.next() : null;
            } else if (b == null || a.compareTo(b) < 0) {
                c = a;
                a = i.hasNext() ? i.next() : null;
            } else if (a == null || b.compareTo(a) < 0) {
                c = b;
                b = j.hasNext() ? j.next() : null;
            } else {
                c = a;
                a = i.hasNext() ? i.next() : null;
                IntInterval intInterval = b = j.hasNext() ? j.next() : null;
            }
            if (t == null) {
                t = c;
                continue;
            }
            if (t.containsAll(c)) continue;
            if (!t.containsAny(c) && t.right + 1 != c.left) {
                s.add(t);
                t = c;
                continue;
            }
            t = new IntInterval(t.left, c.right);
        }
        s.add(t);
        return AbstractIntRange.makeRange(s);
    }

    @Override
    public IntRange meet(IntRange r) {
        TreeSet<IntInterval> s = new TreeSet<IntInterval>();
        Iterator<IntInterval> i = this.intervals().iterator();
        Iterator<IntInterval> j = r.intervals().iterator();
        IntInterval t = null;
        if (this.cardinality() == 0L || r.cardinality() == 0L) {
            return O;
        }
        IntInterval a = i.hasNext() ? i.next() : null;
        IntInterval b = j.hasNext() ? j.next() : null;
        while (a != null || b != null) {
            IntInterval c;
            if (b == null) {
                c = a;
                a = i.hasNext() ? i.next() : null;
            } else if (a == null) {
                c = b;
                b = j.hasNext() ? j.next() : null;
            } else if (b == null || a.compareTo(b) < 0) {
                c = a;
                a = i.hasNext() ? i.next() : null;
            } else if (a == null || b.compareTo(a) < 0) {
                c = b;
                b = j.hasNext() ? j.next() : null;
            } else {
                c = a;
                a = i.hasNext() ? i.next() : null;
                IntInterval intInterval = b = j.hasNext() ? j.next() : null;
            }
            if (t == null) {
                t = c;
                continue;
            }
            if (t.containsAll(c)) {
                s.add(c);
                continue;
            }
            if (!t.containsAny(c)) {
                t = c;
                continue;
            }
            s.add(new IntInterval(c.left, t.right));
            t = c;
        }
        return AbstractIntRange.makeRange(s);
    }

    @Override
    public IntRange difference(IntRange r) {
        return this.meet(r.complement());
    }

    @Override
    public IntRange xor(IntRange r) {
        return this.join(r).difference(this.meet(r));
    }

    @Override
    public IntRange complement() {
        TreeSet<IntInterval> s = new TreeSet<IntInterval>();
        int c = Integer.MIN_VALUE;
        if (this.cardinality() == 0L) {
            return UINT;
        }
        for (IntInterval i : this.intervals()) {
            if (i.left > Integer.MIN_VALUE) {
                s.add(new IntInterval(c, i.left - 1));
            }
            int n = c = i.right == Integer.MAX_VALUE ? Integer.MIN_VALUE : i.right + 1;
        }
        if (c != Integer.MIN_VALUE) {
            s.add(new IntInterval(c, Integer.MAX_VALUE));
        }
        return AbstractIntRange.makeRange(s);
    }

    @Override
    public Range wrappingRange() {
        RangeAdder ra = new RangeAdder();
        for (IntInterval i : this.intervals()) {
            ra.add(IntervalsInt.newClosedInterval(i.left, i.right));
        }
        return ra.toRange();
    }

    @Override
    public Iterator<Integer> iterator() {
        final Iterator<IntInterval> itr = this.intervals().iterator();
        final int[] c = new int[1];
        final IntInterval[] i = new IntInterval[1];
        if (itr.hasNext()) {
            i[0] = itr.next();
            c[0] = i[0].left;
            return new Iterator<Integer>(){

                @Override
                public boolean hasNext() {
                    return i[0] != null;
                }

                @Override
                public Integer next() {
                    int r = c[0];
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (c[0] < i[0].right) {
                        c[0] = c[0] + 1;
                    } else if (itr.hasNext()) {
                        i[0] = (IntInterval)itr.next();
                        c[0] = i[0].left;
                    } else {
                        i[0] = null;
                    }
                    return r;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Integer next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int hashCode() {
        int r = 17;
        for (IntInterval i : this.intervals()) {
            r = 37 * (r + i.hashCode());
        }
        return r;
    }

    public boolean equals(Object o) {
        if (o instanceof IntRange) {
            return this.intervals().equals(((IntRange)o).intervals());
        }
        return false;
    }
}

