/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.bit;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.util.bit.BitCollection;
import net.morilib.util.bit.BitIterator;
import net.morilib.util.bit.BitVector;
import net.morilib.util.bit.BitVectorIterator;

public abstract class AbstractBitVector
implements BitVector {
    int modcount = 0;

    @Override
    public boolean add(boolean x) {
        return this.add(this.size(), x);
    }

    @Override
    public boolean addAllBoolean(BitCollection col) {
        return this.addAllBoolean(this.size(), col);
    }

    @Override
    public void clear() {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                this.removeAt(i);
                ++i;
            }
        } else {
            BitIterator i = this.bitIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }
    }

    @Override
    public boolean any(boolean x) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getBoolean(i) == x) {
                    return true;
                }
                ++i;
            }
        } else {
            BitIterator i = this.bitIterator();
            while (i.hasNext()) {
                if (i.next() != x) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean every(boolean x) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getBoolean(i) != x) {
                    return false;
                }
                ++i;
            }
        } else {
            BitIterator i = this.bitIterator();
            while (i.hasNext()) {
                if (i.next() == x) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public BitIterator bitIterator() {
        return new Itr();
    }

    @Override
    public boolean[] toBooleanArray() {
        return this.toBooleanArray(new boolean[0]);
    }

    @Override
    public boolean[] toBooleanArray(boolean[] arr) {
        boolean[] res;
        boolean[] blArray = res = arr.length < this.size() ? new boolean[this.size()] : arr;
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                res[i] = this.getBoolean(i);
                ++i;
            }
        } else {
            BitIterator itr = this.bitIterator();
            int i = 0;
            while (itr.hasNext()) {
                res[i] = itr.next();
                ++i;
            }
        }
        return res;
    }

    @Override
    public boolean add(int index, boolean x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllBoolean(int index, BitCollection col) {
        boolean r = false;
        if (col instanceof BitVector && col instanceof RandomAccess) {
            int i = index;
            while (i < col.size()) {
                this.add(i, ((BitVector)col).getBoolean(i));
                r = true;
                ++i;
            }
        } else {
            BitIterator itr = col.bitIterator();
            int i = index;
            while (itr.hasNext()) {
                this.add(i, itr.next());
                r = true;
                ++i;
            }
        }
        return r;
    }

    @Override
    public int indexOf(boolean x) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getBoolean(i) == x) {
                    return i;
                }
                ++i;
            }
        } else {
            BitIterator itr = this.bitIterator();
            int i = 0;
            while (itr.hasNext()) {
                if (itr.next() == x) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(boolean x) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getBoolean(i) == x) {
                    return i;
                }
                --i;
            }
        } else {
            BitVectorIterator itr = this.bitVectorIterator();
            int i = this.size() - 1;
            while (itr.hasPrevious()) {
                if (itr.previous() == x) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    @Override
    public BitVectorIterator bitVectorIterator() {
        return new Itr();
    }

    @Override
    public BitVectorIterator bitVectorIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return new Itr(index);
    }

    @Override
    public boolean removeAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean set(int index, boolean x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitVector subVector(int start, int end) {
        final int s = start;
        final int e = end;
        if (s < 0 || s >= this.size()) {
            throw new IndexOutOfBoundsException("" + s);
        }
        if (e < 0 || e > this.size()) {
            throw new IndexOutOfBoundsException("" + e);
        }
        if (e < s) {
            throw new IllegalArgumentException();
        }
        return new AbstractBitVector(){

            @Override
            public boolean add(int index, boolean x) {
                if (index < 0 || index > e - s) {
                    throw new IndexOutOfBoundsException("" + index);
                }
                return AbstractBitVector.this.add(s + index, x);
            }

            @Override
            public boolean removeAt(int index) {
                if (index < 0 || index >= e - s) {
                    throw new IndexOutOfBoundsException("" + index);
                }
                return AbstractBitVector.this.removeAt(s + index);
            }

            @Override
            public boolean set(int index, boolean x) {
                if (index < 0 || index >= e - s) {
                    throw new IndexOutOfBoundsException("" + index);
                }
                return AbstractBitVector.this.set(s + index, x);
            }

            @Override
            public boolean getBoolean(int index) {
                if (index < 0 || index >= e - s) {
                    throw new IndexOutOfBoundsException("" + index);
                }
                return AbstractBitVector.this.getBoolean(s + index);
            }

            @Override
            public int size() {
                return e - s;
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Boolean) {
            return this.any((Boolean)o);
        }
        return false;
    }

    @Override
    public Iterator<Boolean> iterator() {
        final BitIterator b = this.bitIterator();
        return new Iterator<Boolean>(){

            @Override
            public boolean hasNext() {
                return b.hasNext();
            }

            @Override
            public Boolean next() {
                return b.next();
            }

            @Override
            public void remove() {
                b.remove();
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Boolean[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Boolean[] res;
        Boolean[] booleanArray = res = a.length < this.size() ? new Boolean[this.size()] : (Boolean[])a;
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                res[i] = this.getBoolean(i);
                ++i;
            }
        } else {
            BitIterator itr = this.bitIterator();
            int i = 0;
            while (itr.hasNext()) {
                res[i] = itr.next();
                ++i;
            }
        }
        return res;
    }

    @Override
    public boolean add(Boolean e) {
        return this.add((boolean)e);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Boolean) {
            BitIterator itr = this.bitIterator();
            boolean r = false;
            while (itr.hasNext()) {
                if (itr.next() != ((Boolean)o).booleanValue()) continue;
                itr.remove();
                r = true;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.contains(Boolean.TRUE)) {
            return c.contains(Boolean.FALSE) ? !this.isEmpty() : this.any(true);
        }
        return c.contains(Boolean.FALSE) ? this.any(false) : false;
    }

    @Override
    public boolean addAll(Collection<? extends Boolean> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Boolean> c) {
        boolean r = false;
        if (c instanceof RandomAccess) {
            int i = index;
            while (i < this.size()) {
                Boolean x = (Boolean)((List)c).get(i);
                if (x == null) {
                    throw new NullPointerException();
                }
                this.add(i, (boolean)x);
                r = true;
                ++i;
            }
        } else {
            Iterator<? extends Boolean> itr = c.iterator();
            int i = index;
            while (itr.hasNext()) {
                Boolean x = itr.next();
                if (x == null) {
                    throw new NullPointerException();
                }
                this.add(i, (boolean)x);
                r = true;
                ++i;
            }
        }
        return r;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c.contains(Boolean.TRUE)) {
            if (c.contains(Boolean.FALSE)) {
                boolean r = this.isEmpty();
                this.clear();
                return !r;
            }
            return this.remove(Boolean.TRUE);
        }
        if (c.contains(Boolean.FALSE)) {
            return this.remove(Boolean.FALSE);
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c.contains(Boolean.TRUE)) {
            if (c.contains(Boolean.FALSE)) {
                return false;
            }
            return this.remove(Boolean.FALSE);
        }
        if (c.contains(Boolean.FALSE)) {
            return this.remove(Boolean.TRUE);
        }
        boolean r = this.isEmpty();
        this.clear();
        return !r;
    }

    @Override
    public Boolean get(int index) {
        return this.getBoolean(index);
    }

    @Override
    public Boolean set(int index, Boolean element) {
        if (element == null) {
            throw new NullPointerException();
        }
        return this.set(index, (boolean)element);
    }

    @Override
    public void add(int index, Boolean element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.add(index, (boolean)element);
    }

    @Override
    public Boolean remove(int index) {
        return this.removeAt(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Boolean) {
            return this.indexOf((Boolean)o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Boolean) {
            return this.lastIndexOf((Boolean)o);
        }
        return -1;
    }

    @Override
    public ListIterator<Boolean> listIterator() {
        final BitVectorIterator b = this.bitVectorIterator();
        return new ListIterator<Boolean>(){

            @Override
            public boolean hasNext() {
                return b.hasNext();
            }

            @Override
            public Boolean next() {
                return b.next();
            }

            @Override
            public boolean hasPrevious() {
                return b.hasPrevious();
            }

            @Override
            public Boolean previous() {
                return b.previous();
            }

            @Override
            public int nextIndex() {
                return b.nextIndex();
            }

            @Override
            public int previousIndex() {
                return b.previousIndex();
            }

            @Override
            public void remove() {
                b.remove();
            }

            @Override
            public void set(Boolean e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                b.set(e);
            }

            @Override
            public void add(Boolean e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                b.add(e);
            }
        };
    }

    @Override
    public ListIterator<Boolean> listIterator(int index) {
        final BitVectorIterator b = this.bitVectorIterator(index);
        return new ListIterator<Boolean>(){

            @Override
            public boolean hasNext() {
                return b.hasNext();
            }

            @Override
            public Boolean next() {
                return b.next();
            }

            @Override
            public boolean hasPrevious() {
                return b.hasPrevious();
            }

            @Override
            public Boolean previous() {
                return b.previous();
            }

            @Override
            public int nextIndex() {
                return b.nextIndex();
            }

            @Override
            public int previousIndex() {
                return b.previousIndex();
            }

            @Override
            public void remove() {
                b.remove();
            }

            @Override
            public void set(Boolean e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                b.set(e);
            }

            @Override
            public void add(Boolean e) {
                if (e == null) {
                    throw new NullPointerException();
                }
                b.add(e);
            }
        };
    }

    @Override
    public List<Boolean> subList(int fromIndex, int toIndex) {
        return this.subVector(fromIndex, toIndex);
    }

    @Override
    public void negate() {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                this.set(i, !this.getBoolean(i));
                ++i;
            }
        } else {
            BitVectorIterator i = this.bitVectorIterator();
            while (i.hasNext()) {
                i.set(!i.next());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BitVector) {
            BitVector b = (BitVector)o;
            if (this.size() != b.size()) {
                return false;
            }
            if (this instanceof RandomAccess && o instanceof RandomAccess) {
                int i = 0;
                while (i < this.size()) {
                    if (this.getBoolean(i) != b.getBoolean(i)) {
                        return false;
                    }
                    ++i;
                }
            } else {
                BitVectorIterator i = this.bitVectorIterator();
                BitVectorIterator j = b.bitVectorIterator();
                while (i.hasNext()) {
                    if (i.next() == j.next()) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int r = 0;
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size() && i < 32) {
                r = this.getBoolean(i) ? r | 1 << i : r & ~(1 << i);
                ++i;
            }
        } else {
            BitVectorIterator i = this.bitVectorIterator();
            int c = 0;
            while (i.hasNext() && c < 32) {
                r = i.next() ? r | 1 << c : r & ~(1 << c);
                ++c;
            }
        }
        return (17 * r + this.size()) * 37;
    }

    public String toString() {
        BitVectorIterator i = this.bitVectorIterator();
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("[");
        while (i.hasNext()) {
            b.append(d);
            b.append(i.next());
            d = " ,";
        }
        b.append("]");
        return b.toString();
    }

    private class Itr
    implements BitVectorIterator {
        private int index;
        private int expectModcount;
        private boolean modified;

        private Itr(int i) {
            this.index = i;
            this.expectModcount = AbstractBitVector.this.modcount;
            this.modified = true;
        }

        private Itr() {
            this.index = -10;
            this.expectModcount = AbstractBitVector.this.modcount;
            this.modified = true;
        }

        @Override
        public boolean next() {
            if (this.index == -10) {
                this.index = 0;
            } else {
                if (this.index >= AbstractBitVector.this.size()) {
                    throw new NoSuchElementException();
                }
                ++this.index;
            }
            this.modified = false;
            return AbstractBitVector.this.getBoolean(this.index);
        }

        @Override
        public boolean hasNext() {
            return this.index == -10 ? AbstractBitVector.this.size() > 0 : this.index + 1 < AbstractBitVector.this.size();
        }

        private void checkCon() {
            if (this.expectModcount != AbstractBitVector.this.modcount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            this.checkCon();
            if (this.modified) {
                throw new IllegalStateException();
            }
            AbstractBitVector.this.removeAt(this.index--);
            this.expectModcount = AbstractBitVector.this.modcount;
            this.modified = true;
        }

        @Override
        public void add(boolean x) {
            this.checkCon();
            if (this.index == -10) {
                this.index = 0;
            }
            AbstractBitVector.this.add(this.index++, x);
            this.expectModcount = AbstractBitVector.this.modcount;
            this.modified = true;
        }

        @Override
        public boolean hasPrevious() {
            return this.index == -10 ? AbstractBitVector.this.size() > 0 : this.index > 0;
        }

        @Override
        public int nextIndex() {
            return this.index == -10 ? 0 : this.index + 1;
        }

        @Override
        public boolean previous() {
            if (this.index == -10) {
                this.index = AbstractBitVector.this.size();
            } else if (this.index < 0) {
                throw new NoSuchElementException();
            }
            this.modified = false;
            return AbstractBitVector.this.getBoolean(--this.index);
        }

        @Override
        public int previousIndex() {
            return this.index == -10 ? AbstractBitVector.this.size() - 1 : this.index - 1;
        }

        @Override
        public void set(boolean x) {
            if (this.modified) {
                throw new IllegalStateException();
            }
            this.checkCon();
            AbstractBitVector.this.set(this.index, x);
            this.expectModcount = AbstractBitVector.this.modcount;
        }
    }
}

