/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.morilib.util.codec.Base64Encoder;
import net.morilib.util.codec.DecodeException;
import net.morilib.util.codec.Decoder;

public class Base64Decoder
implements Decoder {
    private static final byte INV = -1;
    private static final byte[] _CRLF = new byte[]{13, 10};
    private static final byte[] _CR = new byte[]{13};
    private static final byte[] _LF = new byte[]{10};
    private static final byte[] _NONE = null;
    private static final byte[][] _NEWLS = new byte[][]{_CRLF, _CR, _LF, _NONE};
    public static final int CRLF = 0;
    public static final int CR = 1;
    public static final int LF = 2;
    public static final int NONE = 3;
    public static final Base64Decoder STANDARD = new Base64Decoder(Base64Encoder.STANDARD_B64, 61, 0);
    public static final Base64Decoder UTF7 = new Base64Decoder(Base64Encoder.STANDARD_B64, -1, 3);
    public static final Base64Decoder FILE = new Base64Decoder(Base64Encoder.FILE_B64, -1, 3);
    public static final Base64Decoder URL = new Base64Decoder(Base64Encoder.URL_B64, -1, 3);
    public static final Base64Decoder NMTOKEN = new Base64Decoder(Base64Encoder.NMTOKEN_B64, -1, 3);
    public static final Base64Decoder RE = new Base64Decoder(Base64Encoder.RE_B64, -1, 3);
    private byte[] charinv;
    private int padding;
    private byte[] newline;

    public static Base64Decoder newMime() {
        return new Base64Decoder(Base64Encoder.STANDARD_B64, 61, 0);
    }

    private static byte[] _copy(byte[] s) {
        byte[] r = new byte[s.length];
        System.arraycopy(s, 0, r, 0, s.length);
        return r;
    }

    public static Base64Decoder getInstance(byte[] chars, int padding, int newline) {
        return new Base64Decoder(Base64Decoder._copy(chars), padding, newline);
    }

    Base64Decoder(byte[] chars, int padding, int newline) {
        if (newline < 0 || newline > 3) {
            throw new IllegalArgumentException();
        }
        if (chars == null) {
            throw new NullPointerException();
        }
        if (chars.length != 64) {
            throw new IllegalArgumentException();
        }
        this.charinv = new byte[96];
        this.padding = padding;
        this.newline = _NEWLS[newline];
        Arrays.fill(this.charinv, (byte)-1);
        int i = 0;
        while (i < chars.length) {
            if (chars[i] < 32) {
                throw new IllegalArgumentException();
            }
            this.charinv[chars[i] - 32] = (byte)i;
            ++i;
        }
    }

    @Override
    public void decode(OutputStream wr, InputStream ins) throws IOException, DecodeException {
        int c;
        int state = 0;
        int r = 0;
        int l = 0;
        int x = 0;
        while ((c = ins.read()) >= 0) {
            if (state == 2) {
                if (c != this.newline[x++]) {
                    throw new DecodeException();
                }
                if (this.newline.length != x) continue;
                state = 0;
                continue;
            }
            if (c == this.padding) {
                state = 1;
                continue;
            }
            if (state == 1) {
                throw new DecodeException();
            }
            if (this.newline != null && c == this.newline[0]) {
                x = 1;
                state = 2;
                continue;
            }
            if (c > 127 || c < 32) {
                throw new DecodeException();
            }
            if (this.charinv[c - 32] == -1) {
                throw new DecodeException();
            }
            r = (r << 6) + this.charinv[c - 32];
            if ((l += 6) < 8) continue;
            wr.write(r >> l - 8 & 0xFF);
            r &= (1 << (l -= 8)) - 1;
        }
    }

    @Override
    public byte[] decode(String s) throws DecodeException {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        ByteArrayInputStream ins = new ByteArrayInputStream(s.getBytes());
        try {
            this.decode(ous, ins);
            return ous.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

