/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.morilib.util.codec.Encoder;

public class Base64Encoder
implements Encoder {
    static final byte[] STANDARD_B64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] FILE_B64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 45};
    static final byte[] URL_B64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    static final byte[] NMTOKEN_B64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 46, 45};
    static final byte[] RE_B64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 33, 45};
    private static final byte[] _CRLF = new byte[]{13, 10};
    private static final byte[] _CR = new byte[]{13};
    private static final byte[] _LF = new byte[]{10};
    private static final byte[] _NONE = null;
    private static final byte[][] _NEWLS = new byte[][]{_CRLF, _CR, _LF, _NONE};
    public static final int CRLF = 0;
    public static final int CR = 1;
    public static final int LF = 2;
    public static final int NONE = 3;
    public static final Base64Encoder STANDARD = new Base64Encoder(STANDARD_B64, 61, 64, 0);
    public static final Base64Encoder UTF7 = new Base64Encoder(STANDARD_B64, -1, -1, 3);
    public static final Base64Encoder FILE = new Base64Encoder(FILE_B64, -1, -1, 3);
    public static final Base64Encoder URL = new Base64Encoder(URL_B64, -1, -1, 3);
    public static final Base64Encoder NMTOKEN = new Base64Encoder(NMTOKEN_B64, -1, -1, 3);
    public static final Base64Encoder RE = new Base64Encoder(RE_B64, -1, -1, 3);
    private byte[] chars;
    private int padding;
    private int maxlength;
    private byte[] newline;

    private static byte[] _copy(byte[] s) {
        byte[] r = new byte[s.length];
        System.arraycopy(s, 0, r, 0, s.length);
        return r;
    }

    public static Base64Encoder getInstance(byte[] chars, int padding, int maxlength, int newline) {
        return new Base64Encoder(Base64Encoder._copy(chars), padding, maxlength, newline);
    }

    Base64Encoder(byte[] chars, int padding, int maxlength, int newline) {
        if (newline < 0 || newline > 3) {
            throw new IllegalArgumentException();
        }
        if (chars == null) {
            throw new NullPointerException();
        }
        if (chars.length != 64) {
            throw new IllegalArgumentException();
        }
        this.chars = chars;
        this.padding = padding;
        this.maxlength = maxlength;
        this.newline = _NEWLS[newline];
    }

    @Override
    public void encode(OutputStream wr, InputStream ins) throws IOException {
        int w;
        int c;
        int r = 0;
        int l = 0;
        int o = 0;
        int n = 0;
        while ((c = ins.read()) >= 0) {
            r = (r << 8) + c;
            int x = l += 8;
            while (x >= 6) {
                w = r >> x - 6 & 0x3F;
                wr.write(this.chars[w]);
                if (this.maxlength > 0 && ++n >= this.maxlength) {
                    wr.write(this.newline);
                    n %= this.maxlength;
                }
                x -= 6;
            }
            o = (o + l / 6) % 4;
            r &= (1 << (l %= 6)) - 1;
        }
        if (l > 0) {
            w = r << 6 - l;
            wr.write(this.chars[w]);
            o = (o + 1) % 4;
        }
        if (this.padding >= 0 && o > 0) {
            while (o < 4) {
                wr.write(this.padding);
                ++o;
            }
        }
    }

    @Override
    public String encode(byte[] a) {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        ByteArrayInputStream ins = new ByteArrayInputStream(a);
        try {
            this.encode(ous, ins);
            return new String(ous.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

