/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.morilib.util.io.IllegalUTFException;

public final class UTF8 {
    private UTF8() {
    }

    private static void chk2(int c) throws IOException {
        if (c < 128) {
            throw new IllegalUTFException();
        }
    }

    private static int chk3(int c) throws IOException {
        if ((c & 0xC0) != 128) {
            throw new IllegalUTFException();
        }
        return c & 0x3F;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int read(InputStream ins) throws IOException {
        int c;
        int r = -1;
        int state = 0;
        block18: while ((c = ins.read()) >= 0) {
            if (state > 0) {
                UTF8.chk2(c);
            }
            switch (state) {
                case 0: {
                    r = 0;
                    if ((c & 0x80) == 0) {
                        r = c;
                        break block18;
                    }
                    if ((c & 0xE0) == 192) {
                        r = (c & 0x1F) << 6;
                        if (r < 128) {
                            throw new IllegalUTFException();
                        }
                        state = 10;
                        break;
                    }
                    if ((c & 0xF0) == 224) {
                        r = (c & 0xF) << 12;
                        state = 20;
                        break;
                    }
                    if ((c & 0xF8) == 240) {
                        r = (c & 7) << 16;
                        state = 30;
                        break;
                    }
                    if ((c & 0xFC) == 248) {
                        r = (c & 3) << 24;
                        state = 40;
                        break;
                    }
                    if ((c & 0xFE) != 252) {
                        throw new IllegalUTFException();
                    }
                    r = (c & 1) << 30;
                    state = 50;
                    break;
                }
                case 10: {
                    r |= UTF8.chk3(c);
                    state = 0;
                    break block18;
                }
                case 20: {
                    r |= UTF8.chk3(c) << 6;
                    state = 21;
                    break;
                }
                case 21: {
                    if ((r |= UTF8.chk3(c)) < 2048 || r >= 55296 && r <= 55551 || r >= 56320 && r <= 57343) {
                        throw new IllegalUTFException();
                    }
                    state = 0;
                    break block18;
                }
                case 30: {
                    r |= UTF8.chk3(c) << 12;
                    state = 31;
                    break;
                }
                case 31: {
                    r |= UTF8.chk3(c) << 6;
                    state = 32;
                    break;
                }
                case 32: {
                    if ((r |= UTF8.chk3(c)) < 65536) {
                        throw new IllegalUTFException();
                    }
                    state = 0;
                    break block18;
                }
                case 40: {
                    r |= UTF8.chk3(c) << 18;
                    state = 41;
                    break;
                }
                case 41: {
                    r |= UTF8.chk3(c) << 12;
                    state = 42;
                    break;
                }
                case 42: {
                    r |= UTF8.chk3(c) << 6;
                    state = 43;
                    break;
                }
                case 43: {
                    if ((r |= UTF8.chk3(c)) < 0x200000) {
                        throw new IllegalUTFException();
                    }
                    state = 0;
                    break block18;
                }
                case 50: {
                    r |= UTF8.chk3(c) << 24;
                    state = 51;
                    break;
                }
                case 51: {
                    r |= UTF8.chk3(c) << 18;
                    state = 52;
                    break;
                }
                case 52: {
                    r |= UTF8.chk3(c) << 12;
                    state = 53;
                    break;
                }
                case 53: {
                    r |= UTF8.chk3(c) << 6;
                    state = 54;
                    break;
                }
                case 54: {
                    if ((r |= UTF8.chk3(c)) < 0x4000000) {
                        throw new IllegalUTFException();
                    }
                    state = 0;
                    break block18;
                }
            }
        }
        if (state != 0) {
            throw new IllegalUTFException();
        }
        return r;
    }

    public static void write(OutputStream ous, int c) throws IOException {
        if (c < 0 || c >= 55296 && c <= 55551 || c >= 56320 && c <= 57343) {
            throw new IllegalUTFException();
        }
        if (c < 128) {
            ous.write(c);
        } else if (c < 2048) {
            ous.write(0xC0 | c >> 6 & 0x3F);
            ous.write(0x80 | c & 0x3F);
        } else if (c < 65536) {
            ous.write(0xE0 | c >> 12 & 0x3F);
            ous.write(0x80 | c >> 6 & 0x3F);
            ous.write(0x80 | c & 0x3F);
        } else if (c < 0x200000) {
            ous.write(0xF0 | c >> 18 & 0x3F);
            ous.write(0x80 | c >> 12 & 0x3F);
            ous.write(0x80 | c >> 6 & 0x3F);
            ous.write(0x80 | c & 0x3F);
        } else if (c < 0x4000000) {
            ous.write(0xF8 | c >> 24 & 0x3F);
            ous.write(0x80 | c >> 18 & 0x3F);
            ous.write(0x80 | c >> 12 & 0x3F);
            ous.write(0x80 | c >> 6 & 0x3F);
            ous.write(0x80 | c & 0x3F);
        } else {
            ous.write(0xFC | c >> 30 & 0x3F);
            ous.write(0x80 | c >> 24 & 0x3F);
            ous.write(0x80 | c >> 18 & 0x3F);
            ous.write(0x80 | c >> 12 & 0x3F);
            ous.write(0x80 | c >> 6 & 0x3F);
            ous.write(0x80 | c & 0x3F);
        }
    }
}

