/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.DoubleArrayVector;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.DoubleCollections;
import net.morilib.util.primitive.DoubleList;
import net.morilib.util.primitive.DoubleVector;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.DoubleVectorIterator;

public abstract class AbstractDoubleVector
extends AbstractDoubleCollection
implements DoubleVector,
RandomAccess {
    private static final long serialVersionUID = 3332872309405682099L;
    protected transient int modCount = 0;

    @Override
    public boolean addAllDouble(int index, DoubleCollection a) {
        int i2 = index;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        DoubleIterator i = a.doubleIterator();
        while (i.hasNext()) {
            this.addDouble(i2++, i.next());
        }
        return true;
    }

    @Override
    public double first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getDouble(0);
    }

    @Override
    public int indexOfDouble(double v) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getDouble(i) == v) {
                    return i;
                }
                ++i;
            }
        } else {
            DoubleVectorIterator i = this.doubleVectorIterator();
            int j = 0;
            while (i.hasNext()) {
                if (i.next() == v) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public DoubleList rest() {
        return this.subVector(1, this.size());
    }

    @Override
    public DoubleList rest(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            return DoubleCollections.EMPTY_VECTOR;
        }
        return this.subVector(index, this.size());
    }

    @Override
    public boolean addDouble(double v) {
        ++this.modCount;
        this.addDouble(this.size(), v);
        return true;
    }

    @Override
    public boolean addAllDouble(DoubleCollection a) {
        return this.addAllDouble(this.size(), a);
    }

    @Override
    public boolean addAllDouble(DoubleCollection ... as) {
        int nsize = 0;
        DoubleCollection[] doubleCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleCollection a = doubleCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            boolean r = false;
            ++this.modCount;
            DoubleCollection[] doubleCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                DoubleCollection a = doubleCollectionArray2[n];
                r = this.addAllDouble(a) | r;
                ++n;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean addAllDouble(Collection<? extends DoubleCollection> as) {
        int nsize = 0;
        for (DoubleCollection doubleCollection : as) {
            nsize += doubleCollection.size();
        }
        if (nsize > 0) {
            int n;
            boolean bl = false;
            ++this.modCount;
            for (DoubleCollection doubleCollection : as) {
                n = this.addAllDouble(doubleCollection) | n;
            }
            return n != 0;
        }
        return false;
    }

    @Override
    public boolean containsDouble(double v) {
        return this.indexOfDouble(v) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean addAllDouble(double[] a) {
        return this.addAllDouble(this.size(), (DoubleCollection)new DoubleArrayVector(a));
    }

    @Override
    public boolean addAllDouble(int ptr, double[] a) {
        return this.addAllDouble(ptr, (DoubleCollection)new DoubleArrayVector(a));
    }

    @Override
    public DoubleIterator doubleIterator() {
        return new Itr(null, null);
    }

    @Override
    public boolean removeDouble(double v) {
        int ind = this.indexOfDouble(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean remove(Object v) {
        int ind = this.indexOf(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Double> a) {
        ++this.modCount;
        return this.addAll(this.size(), a);
    }

    @Override
    public boolean contains(Object v) {
        return this.indexOf(v) >= 0;
    }

    @Override
    public int lastIndexOfDouble(double v) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getDouble(i) == v) {
                    return i;
                }
                --i;
            }
        } else {
            DoubleVectorIterator i = this.doubleVectorIterator();
            while (i.hasNext()) {
                i.next();
            }
            int j = this.size() - 1;
            while (i.hasPrevious()) {
                if (i.previous() == v) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public DoubleVectorIterator doubleVectorIterator() {
        return this.doubleVectorIterator(0);
    }

    @Override
    public DoubleVectorIterator doubleVectorIterator(int index) {
        return new VItr();
    }

    @Override
    public DoubleVector subVector(int start, int end) {
        if (start < 0 || start >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new SubV(this, start, end);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Double> c) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i2 = index;
        ++this.modCount;
        if (c.isEmpty()) {
            return false;
        }
        Iterator<? extends Double> i = c.iterator();
        while (i.hasNext()) {
            this.add(i2++, i.next());
        }
        return true;
    }

    @Override
    public Double get(int index) {
        return this.getDouble(index);
    }

    @Override
    public Double set(int index, Double element) {
        return this.setDouble(index, element);
    }

    @Override
    public void add(int index, Double element) {
        this.addDouble(index, element);
    }

    @Override
    public Double remove(int index) {
        return this.removeAt(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Double) {
            return this.indexOfDouble((Double)o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Double) {
            return this.lastIndexOfDouble((Double)o);
        }
        return -1;
    }

    @Override
    public ListIterator<Double> listIterator() {
        final DoubleVectorIterator i = this.doubleVectorIterator();
        return new ListIterator<Double>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Double next() {
                return i.next();
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public Double previous() {
                return i.previous();
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public void set(Double e) {
                i.setDouble(e);
            }

            @Override
            public void add(Double e) {
                i.addDouble(e);
            }
        };
    }

    @Override
    public ListIterator<Double> listIterator(int index) {
        return this.listIterator(0);
    }

    @Override
    public List<Double> subList(int fromIndex, int toIndex) {
        final DoubleVector v = this.subVector(fromIndex, toIndex);
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return (Double)v.get(index);
            }

            @Override
            public int size() {
                return AbstractDoubleVector.this.size();
            }

            @Override
            public Double set(int index, Double element) {
                return v.set(index, element);
            }

            @Override
            public void add(int index, Double element) {
                v.add(index, element);
            }

            @Override
            public Double remove(int index) {
                return (Double)v.remove(index);
            }
        };
    }

    @Override
    public void add(int index, int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.addDouble(index, v);
    }

    @Override
    public double set(int index, int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.setDouble(index, v);
    }

    @Override
    public int indexOf(int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            return -1;
        }
        return this.indexOfDouble(v);
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.toDoubleArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DoubleVector) {
            DoubleVector v = (DoubleVector)obj;
            if (this.size() != v.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (this.getDouble(i) != v.getDouble(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof DoubleList) {
            DoubleIterator i = this.doubleIterator();
            DoubleIterator j = ((DoubleList)obj).doubleIterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next() == j.next()) continue;
                return false;
            }
            return !i.hasNext() && !j.hasNext();
        }
        return false;
    }

    private class Itr
    implements DoubleIterator {
        int ptr = 0;
        int ptrrem = -1;
        int exModCount;

        private Itr() {
            this.exModCount = AbstractDoubleVector.this.modCount;
        }

        void checks() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractDoubleVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        void checks2() {
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            if (this.ptrrem >= AbstractDoubleVector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractDoubleVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ptr < AbstractDoubleVector.this.size();
        }

        @Override
        public double next() {
            this.checks();
            this.ptrrem = this.ptr;
            return AbstractDoubleVector.this.getDouble(this.ptr++);
        }

        @Override
        public void remove() {
            this.checks2();
            try {
                AbstractDoubleVector.this.removeAt(this.ptrrem);
                this.exModCount = AbstractDoubleVector.this.modCount;
                --this.ptr;
                this.ptrrem = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ Itr(Itr itr, Itr itr2) {
            this();
        }
    }

    private static class SubV
    extends AbstractDoubleVector {
        private DoubleVector vector;
        private int bindex;
        private int eindex;

        private SubV(DoubleVector vector, int b, int e) {
            this.vector = vector;
            this.bindex = b;
            this.eindex = e;
        }

        @Override
        public void addDouble(int index, double v) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ++this.eindex;
            this.vector.addDouble(index + this.bindex, v);
        }

        @Override
        public double getDouble(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.getDouble(index + this.bindex);
        }

        @Override
        public double removeAt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            --this.eindex;
            return this.vector.removeAt(index + this.bindex);
        }

        @Override
        public double setDouble(int index, double v) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.setDouble(index + this.bindex, v);
        }

        @Override
        public int size() {
            return this.eindex - this.bindex;
        }
    }

    private class VItr
    extends Itr
    implements DoubleVectorIterator {
        private VItr() {
        }

        @Override
        public void addDouble(double v) {
            if (this.exModCount != AbstractDoubleVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                this.ptrrem = -1;
                AbstractDoubleVector.this.addDouble(this.ptr++, v);
                this.exModCount = AbstractDoubleVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr > 0;
        }

        @Override
        public int nextIndex() {
            return this.ptr;
        }

        @Override
        public double previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractDoubleVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                double res = AbstractDoubleVector.this.getDouble(this.ptr);
                this.ptrrem = --this.ptr;
                return res;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this.ptr - 1;
        }

        @Override
        public void setDouble(double v) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            if (this.exModCount != AbstractDoubleVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractDoubleVector.this.setDouble(this.ptr, v);
                this.ptrrem = -1;
                this.exModCount = AbstractDoubleVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int v) {
            if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.addDouble(v);
        }

        @Override
        public void set(int v) {
            if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.setDouble(v);
        }
    }
}

