/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractLongCollection;
import net.morilib.util.primitive.LongArrayVector;
import net.morilib.util.primitive.LongCollection;
import net.morilib.util.primitive.LongCollections;
import net.morilib.util.primitive.LongList;
import net.morilib.util.primitive.LongVector;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.iterator.LongVectorIterator;

public abstract class AbstractLongVector
extends AbstractLongCollection
implements LongVector,
RandomAccess {
    private static final long serialVersionUID = 3332872309405682099L;
    protected transient int modCount = 0;

    @Override
    public boolean addAllLong(int index, LongCollection a) {
        int i2 = index;
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        LongIterator i = a.longIterator();
        while (i.hasNext()) {
            this.addLong(i2++, i.next());
        }
        return true;
    }

    @Override
    public long first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLong(0);
    }

    @Override
    public int indexOfLong(long v) {
        if (this instanceof RandomAccess) {
            int i = 0;
            while (i < this.size()) {
                if (this.getLong(i) == v) {
                    return i;
                }
                ++i;
            }
        } else {
            LongVectorIterator i = this.longVectorIterator();
            int j = 0;
            while (i.hasNext()) {
                if (i.next() == v) {
                    return j;
                }
                ++j;
            }
        }
        return -1;
    }

    @Override
    public LongList rest() {
        return this.subVector(1, this.size());
    }

    @Override
    public LongList rest(int index) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.size()) {
            return LongCollections.EMPTY_VECTOR;
        }
        return this.subVector(index, this.size());
    }

    @Override
    public boolean addLong(long v) {
        ++this.modCount;
        this.addLong(this.size(), v);
        return true;
    }

    @Override
    public boolean addAllLong(LongCollection a) {
        return this.addAllLong(this.size(), a);
    }

    @Override
    public boolean addAllLong(LongCollection ... as) {
        int nsize = 0;
        LongCollection[] longCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            LongCollection a = longCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            boolean r = false;
            ++this.modCount;
            LongCollection[] longCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                LongCollection a = longCollectionArray2[n];
                r = this.addAllLong(a) | r;
                ++n;
            }
            return r;
        }
        return false;
    }

    @Override
    public boolean addAllLong(Collection<? extends LongCollection> as) {
        int nsize = 0;
        for (LongCollection longCollection : as) {
            nsize += longCollection.size();
        }
        if (nsize > 0) {
            int n;
            boolean bl = false;
            ++this.modCount;
            for (LongCollection longCollection : as) {
                n = this.addAllLong(longCollection) | n;
            }
            return n != 0;
        }
        return false;
    }

    @Override
    public boolean containsLong(long v) {
        return this.indexOfLong(v) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean addAllLong(long[] a) {
        return this.addAllLong(this.size(), (LongCollection)new LongArrayVector(a));
    }

    @Override
    public boolean addAllLong(int ptr, long[] a) {
        return this.addAllLong(ptr, (LongCollection)new LongArrayVector(a));
    }

    @Override
    public LongIterator longIterator() {
        return new Itr(null, null);
    }

    @Override
    public boolean removeLong(long v) {
        int ind = this.indexOfLong(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean remove(Object v) {
        int ind = this.indexOf(v);
        ++this.modCount;
        if (ind < 0) {
            return false;
        }
        this.removeAt(ind);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> a) {
        ++this.modCount;
        return this.addAll(this.size(), a);
    }

    @Override
    public boolean contains(Object v) {
        return this.indexOf(v) >= 0;
    }

    @Override
    public int lastIndexOfLong(long v) {
        if (this instanceof RandomAccess) {
            int i = this.size() - 1;
            while (i >= 0) {
                if (this.getLong(i) == v) {
                    return i;
                }
                --i;
            }
        } else {
            LongVectorIterator i = this.longVectorIterator();
            while (i.hasNext()) {
                i.next();
            }
            int j = this.size() - 1;
            while (i.hasPrevious()) {
                if (i.previous() == v) {
                    return j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public LongVectorIterator longVectorIterator() {
        return this.longVectorIterator(0);
    }

    @Override
    public LongVectorIterator longVectorIterator(int index) {
        return new VItr();
    }

    @Override
    public LongVector subVector(int start, int end) {
        if (start < 0 || start >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new SubV(this, start, end);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        if (index > this.size() || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int i2 = index;
        ++this.modCount;
        if (c.isEmpty()) {
            return false;
        }
        Iterator<? extends Long> i = c.iterator();
        while (i.hasNext()) {
            this.add(i2++, i.next());
        }
        return true;
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public Long set(int index, Long element) {
        return this.setLong(index, element);
    }

    @Override
    public void add(int index, Long element) {
        this.addLong(index, element);
    }

    @Override
    public Long remove(int index) {
        return this.removeAt(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Long) {
            return this.indexOfLong((Long)o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Long) {
            return this.lastIndexOfLong((Long)o);
        }
        return -1;
    }

    @Override
    public ListIterator<Long> listIterator() {
        final LongVectorIterator i = this.longVectorIterator();
        return new ListIterator<Long>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Long next() {
                return i.next();
            }

            @Override
            public boolean hasPrevious() {
                return i.hasPrevious();
            }

            @Override
            public Long previous() {
                return i.previous();
            }

            @Override
            public int nextIndex() {
                return i.nextIndex();
            }

            @Override
            public int previousIndex() {
                return i.previousIndex();
            }

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public void set(Long e) {
                i.setLong(e);
            }

            @Override
            public void add(Long e) {
                i.addLong(e);
            }
        };
    }

    @Override
    public ListIterator<Long> listIterator(int index) {
        return this.listIterator(0);
    }

    @Override
    public List<Long> subList(int fromIndex, int toIndex) {
        final LongVector v = this.subVector(fromIndex, toIndex);
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return (Long)v.get(index);
            }

            @Override
            public int size() {
                return AbstractLongVector.this.size();
            }

            @Override
            public Long set(int index, Long element) {
                return v.set(index, element);
            }

            @Override
            public void add(int index, Long element) {
                v.add(index, element);
            }

            @Override
            public Long remove(int index) {
                return (Long)v.remove(index);
            }
        };
    }

    @Override
    public void add(int index, int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.addLong(index, v);
    }

    @Override
    public long set(int index, int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.setLong(index, v);
    }

    @Override
    public int indexOf(int v) {
        if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
            return -1;
        }
        return this.indexOfLong(v);
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.toLongArray());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LongVector) {
            LongVector v = (LongVector)obj;
            if (this.size() != v.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (this.getLong(i) != v.getLong(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (obj instanceof LongList) {
            LongIterator i = this.longIterator();
            LongIterator j = ((LongList)obj).longIterator();
            while (i.hasNext() && j.hasNext()) {
                if (i.next() == j.next()) continue;
                return false;
            }
            return !i.hasNext() && !j.hasNext();
        }
        return false;
    }

    private class Itr
    implements LongIterator {
        int ptr = 0;
        int ptrrem = -1;
        int exModCount;

        private Itr() {
            this.exModCount = AbstractLongVector.this.modCount;
        }

        void checks() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractLongVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        void checks2() {
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            if (this.ptrrem >= AbstractLongVector.this.size()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractLongVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ptr < AbstractLongVector.this.size();
        }

        @Override
        public long next() {
            this.checks();
            this.ptrrem = this.ptr;
            return AbstractLongVector.this.getLong(this.ptr++);
        }

        @Override
        public void remove() {
            this.checks2();
            try {
                AbstractLongVector.this.removeAt(this.ptrrem);
                this.exModCount = AbstractLongVector.this.modCount;
                --this.ptr;
                this.ptrrem = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        /* synthetic */ Itr(Itr itr, Itr itr2) {
            this();
        }
    }

    private static class SubV
    extends AbstractLongVector {
        private LongVector vector;
        private int bindex;
        private int eindex;

        private SubV(LongVector vector, int b, int e) {
            this.vector = vector;
            this.bindex = b;
            this.eindex = e;
        }

        @Override
        public void addLong(int index, long v) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            ++this.eindex;
            this.vector.addLong(index + this.bindex, v);
        }

        @Override
        public long getLong(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.getLong(index + this.bindex);
        }

        @Override
        public long removeAt(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            --this.eindex;
            return this.vector.removeAt(index + this.bindex);
        }

        @Override
        public long setLong(int index, long v) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.vector.setLong(index + this.bindex, v);
        }

        @Override
        public int size() {
            return this.eindex - this.bindex;
        }
    }

    private class VItr
    extends Itr
    implements LongVectorIterator {
        private VItr() {
        }

        @Override
        public void addLong(long v) {
            if (this.exModCount != AbstractLongVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                this.ptrrem = -1;
                AbstractLongVector.this.addLong(this.ptr++, v);
                this.exModCount = AbstractLongVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.ptr > 0;
        }

        @Override
        public int nextIndex() {
            return this.ptr;
        }

        @Override
        public long previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            if (this.exModCount != AbstractLongVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                long res = AbstractLongVector.this.getLong(this.ptr);
                this.ptrrem = --this.ptr;
                return res;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this.ptr - 1;
        }

        @Override
        public void setLong(long v) {
            if (!this.hasNext()) {
                throw new IllegalArgumentException();
            }
            if (this.exModCount != AbstractLongVector.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.ptrrem < 0) {
                throw new IllegalStateException();
            }
            try {
                AbstractLongVector.this.setLong(this.ptr, v);
                this.ptrrem = -1;
                this.exModCount = AbstractLongVector.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(int v) {
            if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.addLong(v);
        }

        @Override
        public void set(int v) {
            if ((long)v < Long.MIN_VALUE || (long)v > Long.MAX_VALUE) {
                throw new IllegalArgumentException();
            }
            this.setLong(v);
        }
    }
}

