/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractCharacterVector;
import net.morilib.util.primitive.CharacterCollection;

public class CharacterArrayVector
extends AbstractCharacterVector
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 3332872309405682099L;
    private char[] array;
    private transient int size;

    public CharacterArrayVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new char[initialCapacity];
    }

    public CharacterArrayVector() {
        this(10);
    }

    public CharacterArrayVector(char[] bytes) {
        this.array = new char[bytes.length];
        this.size = this.array.length;
        System.arraycopy(bytes, 0, this.array, 0, bytes.length);
    }

    public CharacterArrayVector(CharacterCollection a) {
        this.array = a.toCharArray();
        this.size = this.array.length;
    }

    public CharacterArrayVector(CharacterCollection ... as) {
        this.size = 0;
        CharacterCollection[] characterCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            CharacterCollection a = characterCollectionArray[n2];
            this.size += a.size();
            ++n2;
        }
        int s2 = 0;
        this.array = new char[this.size];
        CharacterCollection[] characterCollectionArray2 = as;
        int n3 = as.length;
        n = 0;
        while (n < n3) {
            CharacterCollection a = characterCollectionArray2[n];
            char[] b = a.toCharArray();
            System.arraycopy(b, 0, this.array, s2, b.length);
            s2 += a.size();
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public CharacterArrayVector(Collection<? extends CharacterCollection> as) {
        this.size = 0;
        for (CharacterCollection characterCollection : as) {
            this.size += characterCollection.size();
        }
        boolean bl = false;
        this.array = new char[this.size];
        for (CharacterCollection characterCollection : as) {
            void var2_7;
            char[] b = characterCollection.toCharArray();
            System.arraycopy(b, 0, this.array, (int)var2_7, b.length);
            var2_7 += characterCollection.size();
        }
    }

    public void ensureCapacity(int nsize) {
        if (nsize > this.array.length) {
            int ns = nsize;
            while (ns < this.array.length) {
                int n = ns = this.array.length < 0x4CCCCCCA ? this.array.length / 3 * 5 + 1 : Integer.MAX_VALUE;
            }
            char[] b = new char[ns];
            System.arraycopy(this.array, 0, b, 0, this.size);
            this.array = b;
        }
    }

    @Override
    public void addChar(int index, char v) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        ++this.modCount;
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = v;
        ++this.size;
    }

    @Override
    public boolean addAllChar(int index, CharacterCollection a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        char[] b = a.toCharArray();
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public char getChar(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public char removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        char res = this.array[index];
        ++this.modCount;
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return res;
    }

    @Override
    public char setChar(int index, char v) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        char res = this.array[index];
        ++this.modCount;
        this.array[index] = v;
        return res;
    }

    @Override
    public boolean addAllChar(CharacterCollection a) {
        char[] b = a.toCharArray();
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllChar(CharacterCollection ... as) {
        int nsize = 0;
        CharacterCollection[] characterCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            CharacterCollection a = characterCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            int s2 = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            CharacterCollection[] characterCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                CharacterCollection a = characterCollectionArray2[n];
                char[] b = a.toCharArray();
                System.arraycopy(b, 0, this.array, s2, b.length);
                s2 += a.size();
                ++n;
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllChar(Collection<? extends CharacterCollection> as) {
        int nsize = 0;
        for (CharacterCollection characterCollection : as) {
            nsize += characterCollection.size();
        }
        if (nsize > 0) {
            int n = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            for (CharacterCollection characterCollection : as) {
                void var3_8;
                char[] b = characterCollection.toCharArray();
                System.arraycopy(b, 0, this.array, (int)var3_8, b.length);
                var3_8 += characterCollection.size();
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAllChar(char[] b) {
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllChar(int index, char[] b) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (b.length == 0) {
            return false;
        }
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public char[] toCharArray() {
        char[] b = new char[this.size];
        System.arraycopy(this.array, 0, b, 0, this.size);
        return b;
    }

    @Override
    public char[] toCharArray(char[] a) {
        if (a.length < this.size) {
            return this.toCharArray();
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.size = this.array.length;
    }
}

