/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import net.morilib.util.primitive.CharacterComparator;
import net.morilib.util.primitive.CharacterVector;
import net.morilib.util.primitive.PrimitiveComparators;

public final class PrimitiveVectors {
    private PrimitiveVectors() {
    }

    public static boolean isSorted(CharacterVector vec) {
        int i = 1;
        while (i < vec.size()) {
            if (((Character)vec.get(i - 1)).charValue() > ((Character)vec.get(i)).charValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSorted(CharacterVector vec, CharacterComparator cmp) {
        int i = 1;
        while (i < vec.size()) {
            if (cmp.compare(vec.getChar(i - 1), vec.getChar(i)) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void merge(CharacterVector vec, CharacterVector mvec) {
        PrimitiveVectors.merge(vec, mvec, PrimitiveComparators.NATURAL_CHAR);
    }

    public static void merge(CharacterVector vec, CharacterVector mvec, CharacterComparator cmp) {
        int i = 0;
        int j = 0;
        while (j < vec.size()) {
            if (i >= vec.size()) {
                vec.add((Character)mvec.get(j++));
                continue;
            }
            int c = cmp.compare(((Character)vec.get(i)).charValue(), ((Character)mvec.get(j)).charValue());
            if (c < 0) {
                ++i;
                continue;
            }
            if (c == 0) {
                ++i;
                ++j;
                continue;
            }
            vec.add(i, (Character)mvec.get(j));
            i += 2;
            ++j;
        }
    }
}

