/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.op;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractFloatCollection;
import net.morilib.util.primitive.FloatCollection;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.op.FloatValueMap;

public abstract class AbstractFloatValueMap<K>
implements FloatValueMap<K> {
    private static final long serialVersionUID = 4823620077843167065L;
    private transient Set<K> keySet = null;
    private transient FloatCollection values = null;

    @Override
    public void clear() {
        Iterator i = this.floatValueEntrySet().iterator();
        while (i.hasNext()) {
            i.remove();
        }
    }

    @Override
    public boolean containsKey(Object k) {
        if (k instanceof Float) {
            this.containsValueElement(((Float)k).floatValue());
        }
        return false;
    }

    @Override
    public boolean containsValueElement(float v) {
        for (FloatValueMap.PrimitiveEntryV e : this.floatValueEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float get(Object k) {
        if (k instanceof Float) {
            for (FloatValueMap.PrimitiveEntryV e : this.floatValueEntrySet()) {
                Object l = e.getKey();
                if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
                return Float.valueOf(e.getValue());
            }
        }
        return null;
    }

    @Override
    public float getElement(Object k) {
        if (k instanceof Float) {
            for (FloatValueMap.PrimitiveEntryV e : this.floatValueEntrySet()) {
                Object l = e.getKey();
                if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
                return e.getValue();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.floatValueEntrySet())) : this.keySet;
    }

    @Override
    public Float put(K k, float v) {
        boolean b = this.containsKey(k);
        float r = this.putElement(k, v);
        return b ? Float.valueOf(r) : null;
    }

    @Override
    public void putAllElement(FloatValueMap<K> map) {
        for (FloatValueMap.PrimitiveEntryV<K> e : map.floatValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection floatValues() {
        return this.values == null ? (this.values = new VCol(this.floatValueEntrySet())) : this.values;
    }

    @Override
    public boolean containsValue(int v) {
        if ((float)v < Float.MIN_VALUE || (float)v > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Float) {
            return this.containsValueElement(((Float)value).floatValue());
        }
        return false;
    }

    @Override
    public Float put(K key, Float value) {
        if (value instanceof Float) {
            return Float.valueOf(this.putElement(key, value.floatValue()));
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Float> m) {
        for (FloatValueMap.PrimitiveEntryV e : this.floatValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<Float> values() {
        final Iterator i = this.floatValueEntrySet().iterator();
        return new AbstractCollection<Float>(){

            @Override
            public Iterator<Float> iterator() {
                return new Iterator<Float>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Float next() {
                        return Float.valueOf(((FloatValueMap.PrimitiveEntryV)i.next()).getValue());
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractFloatValueMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, Float>> entrySet() {
        final Iterator i = this.floatValueEntrySet().iterator();
        return new AbstractSet<Map.Entry<K, Float>>(){

            @Override
            public Iterator<Map.Entry<K, Float>> iterator() {
                return new Iterator<Map.Entry<K, Float>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Float> next() {
                        final FloatValueMap.PrimitiveEntryV e = (FloatValueMap.PrimitiveEntryV)i.next();
                        return new Map.Entry<K, Float>(){

                            @Override
                            public K getKey() {
                                return e.getKey();
                            }

                            @Override
                            public Float getValue() {
                                return Float.valueOf(e.getValue());
                            }

                            @Override
                            public Float setValue(Float value) {
                                return Float.valueOf(e.setValue(value.floatValue()));
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractFloatValueMap.this.size();
            }
        };
    }

    @Override
    public Float remove(Object k) {
        Iterator i = this.floatValueEntrySet().iterator();
        while (i.hasNext()) {
            FloatValueMap.PrimitiveEntryV e = i.next();
            Object l = e.getKey();
            if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
            float r = e.getValue();
            i.remove();
            return Float.valueOf(r);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (FloatValueMap.PrimitiveEntryV e : this.floatValueEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof FloatValueMap)) break block1;
            m = (FloatValueMap)obj;
            i = this.floatValueEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                if (m.containsKey(o.getKey()) && m.getElement(o.getKey()) == o.getValue()) continue;
                return false;
lbl9:
                // 2 sources

                ** while (i.hasNext())
            }
lbl10:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (FloatValueMap.PrimitiveEntryV e : this.floatValueEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractSet<K> {
        private Set<FloatValueMap.PrimitiveEntryV<K>> eset;

        private KSet(Set<FloatValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public K next() {
                    return ((FloatValueMap.PrimitiveEntryV)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatValueMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractFloatValueMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractFloatValueMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractFloatValueMap.this.clear();
        }
    }

    private class VCol
    extends AbstractFloatCollection {
        private Set<FloatValueMap.PrimitiveEntryV<K>> eset;

        private VCol(Set<FloatValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator ei = this.eset.iterator();
            return new FloatIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public float next() {
                    return ((FloatValueMap.PrimitiveEntryV)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractFloatValueMap.this.size();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }
    }
}

