/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.op;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractShortCollection;
import net.morilib.util.primitive.ShortCollection;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.map.op.ShortValueMap;

public abstract class AbstractShortValueMap<K>
implements ShortValueMap<K> {
    private static final long serialVersionUID = 4823620077843167065L;
    private transient Set<K> keySet = null;
    private transient ShortCollection values = null;

    @Override
    public void clear() {
        Iterator i = this.shortValueEntrySet().iterator();
        while (i.hasNext()) {
            i.remove();
        }
    }

    @Override
    public boolean containsKey(Object k) {
        if (k instanceof Short) {
            this.containsValueElement((Short)k);
        }
        return false;
    }

    @Override
    public boolean containsValueElement(short v) {
        for (ShortValueMap.PrimitiveEntryV e : this.shortValueEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public Short get(Object k) {
        if (k instanceof Short) {
            for (ShortValueMap.PrimitiveEntryV e : this.shortValueEntrySet()) {
                Object l = e.getKey();
                if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
                return e.getValue();
            }
        }
        return null;
    }

    @Override
    public short getElement(Object k) {
        if (k instanceof Short) {
            for (ShortValueMap.PrimitiveEntryV e : this.shortValueEntrySet()) {
                Object l = e.getKey();
                if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
                return e.getValue();
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.shortValueEntrySet())) : this.keySet;
    }

    @Override
    public Short put(K k, short v) {
        boolean b = this.containsKey(k);
        short r = this.putElement(k, v);
        return b ? Short.valueOf(r) : null;
    }

    @Override
    public void putAllElement(ShortValueMap<K> map) {
        for (ShortValueMap.PrimitiveEntryV<K> e : map.shortValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection shortValues() {
        return this.values == null ? (this.values = new VCol(this.shortValueEntrySet())) : this.values;
    }

    @Override
    public boolean containsValue(int v) {
        if (v < Short.MIN_VALUE || v > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((short)v);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Short) {
            return this.containsValueElement((Short)value);
        }
        return false;
    }

    @Override
    public Short put(K key, Short value) {
        if (value instanceof Short) {
            return this.putElement(key, value);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Short> m) {
        for (ShortValueMap.PrimitiveEntryV e : this.shortValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<Short> values() {
        final Iterator i = this.shortValueEntrySet().iterator();
        return new AbstractCollection<Short>(){

            @Override
            public Iterator<Short> iterator() {
                return new Iterator<Short>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Short next() {
                        return ((ShortValueMap.PrimitiveEntryV)i.next()).getValue();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractShortValueMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, Short>> entrySet() {
        final Iterator i = this.shortValueEntrySet().iterator();
        return new AbstractSet<Map.Entry<K, Short>>(){

            @Override
            public Iterator<Map.Entry<K, Short>> iterator() {
                return new Iterator<Map.Entry<K, Short>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, Short> next() {
                        final ShortValueMap.PrimitiveEntryV e = (ShortValueMap.PrimitiveEntryV)i.next();
                        return new Map.Entry<K, Short>(){

                            @Override
                            public K getKey() {
                                return e.getKey();
                            }

                            @Override
                            public Short getValue() {
                                return e.getValue();
                            }

                            @Override
                            public Short setValue(Short value) {
                                return e.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractShortValueMap.this.size();
            }
        };
    }

    @Override
    public Short remove(Object k) {
        Iterator i = this.shortValueEntrySet().iterator();
        while (i.hasNext()) {
            ShortValueMap.PrimitiveEntryV e = i.next();
            Object l = e.getKey();
            if ((k != null || l != null) && (k == null || !k.equals(l))) continue;
            short r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ShortValueMap.PrimitiveEntryV e : this.shortValueEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ShortValueMap)) break block1;
            m = (ShortValueMap)obj;
            i = this.shortValueEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                if (m.containsKey(o.getKey()) && m.getElement(o.getKey()) == o.getValue()) continue;
                return false;
lbl9:
                // 2 sources

                ** while (i.hasNext())
            }
lbl10:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ShortValueMap.PrimitiveEntryV e : this.shortValueEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractSet<K> {
        private Set<ShortValueMap.PrimitiveEntryV<K>> eset;

        private KSet(Set<ShortValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<K>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public K next() {
                    return ((ShortValueMap.PrimitiveEntryV)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractShortValueMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractShortValueMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractShortValueMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractShortValueMap.this.clear();
        }
    }

    private class VCol
    extends AbstractShortCollection {
        private Set<ShortValueMap.PrimitiveEntryV<K>> eset;

        private VCol(Set<ShortValueMap.PrimitiveEntryV<K>> eset) {
            this.eset = eset;
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ShortIterator shortIterator() {
            final Iterator ei = this.eset.iterator();
            return new ShortIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public short next() {
                    return ((ShortValueMap.PrimitiveEntryV)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractShortValueMap.this.size();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }
    }
}

