/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.po;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.primitive.AbstractCharacterSet;
import net.morilib.util.primitive.CharacterSet;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.map.po.CharacterMap;

public abstract class AbstractCharacterMap<V>
implements CharacterMap<V> {
    private static final long serialVersionUID = 4823620077843167065L;
    private transient CharacterSet keySet = null;
    private transient Collection<V> values = null;

    @Override
    public void clear() {
        Iterator i = this.charKeyEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValue(Object v) {
        for (CharacterMap.PrimitiveEntryK e : this.charKeyEntrySet()) {
            Object p = e.getValue();
            if ((v != null || p != null) && (v == null || !v.equals(p))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V getElement(char k) {
        for (CharacterMap.PrimitiveEntryK e : this.charKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharacterSet charKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.charKeyEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(CharacterMap<V> map) {
        for (CharacterMap.PrimitiveEntryK<V> e : map.charKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        return this.values == null ? (this.values = new VCol(this.charKeyEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Character) {
            return this.containsKeyElement(((Character)key).charValue());
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof Character) {
            return this.getElement(((Character)key).charValue());
        }
        return null;
    }

    @Override
    public V put(Character key, V value) {
        return this.putElement(key.charValue(), value);
    }

    @Override
    public V remove(Object key) {
        if (key instanceof Character) {
            return this.removeElement(((Character)key).charValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Character, ? extends V> m) {
        for (Map.Entry<Character, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<Character> keySet() {
        return this.charKeySet();
    }

    @Override
    public Set<Map.Entry<Character, V>> entrySet() {
        final Set e = this.charKeyEntrySet();
        return new AbstractSet<Map.Entry<Character, V>>(){

            @Override
            public Iterator<Map.Entry<Character, V>> iterator() {
                final Iterator i = e.iterator();
                return new Iterator<Map.Entry<Character, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<Character, V> next() {
                        final CharacterMap.PrimitiveEntryK o = (CharacterMap.PrimitiveEntryK)i.next();
                        return new Map.Entry<Character, V>(){

                            @Override
                            public Character getKey() {
                                return Character.valueOf(o.getKey());
                            }

                            @Override
                            public V getValue() {
                                return o.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return o.setValue(value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return e.size();
            }
        };
    }

    @Override
    public boolean containsKey(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((char)k);
    }

    @Override
    public boolean containsKeyElement(char k) {
        for (CharacterMap.PrimitiveEntryK e : this.charKeyEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.getElement((char)k);
    }

    @Override
    public V put(int k, V v) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.putElement((char)k, v);
    }

    @Override
    public V removeElement(char k) {
        Iterator i = this.charKeyEntrySet().iterator();
        while (i.hasNext()) {
            CharacterMap.PrimitiveEntryK e = i.next();
            if (e.getKey() != k) continue;
            Object r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public V remove(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((char)k);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (CharacterMap.PrimitiveEntryK e : this.charKeyEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof CharacterMap)) break block1;
            m = (CharacterMap)obj;
            i = this.charKeyEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && (v == null && p == null || v != null && v.equals(p))) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (CharacterMap.PrimitiveEntryK e : this.charKeyEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractCharacterSet {
        private Set<CharacterMap.PrimitiveEntryK<V>> eset;

        private KSet(Set<CharacterMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public CharacterIterator charIterator() {
            final Iterator ei = this.eset.iterator();
            return new CharacterIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public char next() {
                    return ((CharacterMap.PrimitiveEntryK)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractCharacterMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractCharacterMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractCharacterMap.this.clear();
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCollection<V> {
        private Set<CharacterMap.PrimitiveEntryK<V>> eset;

        private VCol(Set<CharacterMap.PrimitiveEntryK<V>> eset) {
            this.eset = eset;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator ei = this.eset.iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public V next() {
                    return ((CharacterMap.PrimitiveEntryK)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractCharacterMap.this.size();
        }
    }
}

