/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.AbstractCharacterCollection;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.CharacterCollection;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.map.op.CharacterValueMap;
import net.morilib.util.primitive.map.po.ByteMap;
import net.morilib.util.primitive.map.pp.ByteCharacterMap;

public abstract class AbstractByteCharacterMap
implements ByteCharacterMap {
    private transient ByteSet keySet = null;
    private transient CharacterCollection values = null;
    private transient Set<ByteMap.PrimitiveEntryK<Character>> entrySetK = null;
    private transient Set<CharacterValueMap.PrimitiveEntryV<Byte>> entrySetV = null;
    private transient Set<Map.Entry<Byte, Character>> entrySet = null;

    @Override
    public void clear() {
        Iterator<ByteCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(char v) {
        for (ByteCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public char f(byte k) {
        for (ByteCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Character getElement(byte k) {
        return Character.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ByteSet byteKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(ByteCharacterMap map) {
        for (ByteCharacterMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Character) {
            return this.containsKeyElement((Byte)key);
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        if (key instanceof Character) {
            return this.getElement((Byte)key);
        }
        return null;
    }

    @Override
    public Character put(Byte key, char value) {
        return this.putElement((byte)key, value);
    }

    @Override
    public Character remove(Object key) {
        if (key instanceof Character) {
            return this.removeElement((Byte)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends Character> m) {
        for (Map.Entry<? extends Byte, ? extends Character> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteSet keySet() {
        return this.byteKeySet();
    }

    @Override
    public Set<Map.Entry<Byte, Character>> entrySet() {
        final Set<ByteCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Byte, Character>>(){

                @Override
                public Iterator<Map.Entry<Byte, Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Byte, Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Byte, Character> next() {
                            final ByteCharacterMap.PrimitiveEntry o = (ByteCharacterMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Byte, Character>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((byte)k);
    }

    @Override
    public boolean containsKeyElement(byte k) {
        for (ByteCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Character get(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return Character.valueOf(this.getElement(Character.valueOf((char)k)));
    }

    @Override
    public Character put(int k, Character v) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.putElement((byte)k, v);
    }

    @Override
    public Character removeElement(byte k) {
        Iterator<ByteCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            ByteCharacterMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            char r = e.getValue();
            i.remove();
            return Character.valueOf(r);
        }
        return null;
    }

    @Override
    public Character remove(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((byte)k);
    }

    @Override
    public Set<ByteMap.PrimitiveEntryK<Character>> byteKeyEntrySet() {
        final Set<ByteCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<ByteMap.PrimitiveEntryK<Character>>(){

                @Override
                public Iterator<ByteMap.PrimitiveEntryK<Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteMap.PrimitiveEntryK<Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteMap.PrimitiveEntryK<Character> next() {
                            final ByteCharacterMap.PrimitiveEntry o = (ByteCharacterMap.PrimitiveEntry)i.next();
                            return new ByteMap.PrimitiveEntryK<Character>(){

                                @Override
                                public byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Character putElement(byte k, Character v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteMap<Character> map) {
        for (ByteMap.PrimitiveEntryK<Character> e : map.byteKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < -128 || v > 127) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((char)v);
    }

    @Override
    public Set<CharacterValueMap.PrimitiveEntryV<Byte>> charValueEntrySet() {
        final Set<ByteCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<CharacterValueMap.PrimitiveEntryV<Byte>>(){

                @Override
                public Iterator<CharacterValueMap.PrimitiveEntryV<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<CharacterValueMap.PrimitiveEntryV<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public CharacterValueMap.PrimitiveEntryV<Byte> next() {
                            final ByteCharacterMap.PrimitiveEntry o = (ByteCharacterMap.PrimitiveEntry)i.next();
                            return new CharacterValueMap.PrimitiveEntryV<Byte>(){

                                @Override
                                public Byte getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public char getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public char setValue(char value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public char getElement(Object k) {
        if (k instanceof Byte) {
            return this.f((Byte)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public char putElement(Byte k, char v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(CharacterValueMap<Byte> map) {
        for (CharacterValueMap.PrimitiveEntryV<Byte> e : map.charValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection charValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Character) {
            return this.containsValueElement(((Character)value).charValue());
        }
        return false;
    }

    @Override
    public Character put(Byte key, Character value) {
        return this.putElement((byte)key, value.charValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (ByteCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof ByteCharacterMap)) break block1;
            m = (ByteCharacterMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).charValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (ByteCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractByteSet {
        private Set<ByteCharacterMap.PrimitiveEntry> eset;

        private KSet(Set<ByteCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<ByteCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public byte next() {
                    return ((ByteCharacterMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteCharacterMap.this.size();
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractByteCharacterMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteCharacterMap.this.clear();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCharacterCollection {
        private Set<ByteCharacterMap.PrimitiveEntry> eset;

        private VCol(Set<ByteCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public CharacterIterator charIterator() {
            final Iterator<ByteCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new CharacterIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public char next() {
                    return ((ByteCharacterMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractByteCharacterMap.this.size();
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsChar(char o) {
            return AbstractByteCharacterMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractByteCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractByteCharacterMap.this.clear();
        }
    }
}

