/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.AbstractCharacterSet;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.CharacterSet;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.map.op.ByteValueMap;
import net.morilib.util.primitive.map.po.CharacterMap;
import net.morilib.util.primitive.map.pp.CharacterByteMap;

public abstract class AbstractCharacterByteMap
implements CharacterByteMap {
    private transient CharacterSet keySet = null;
    private transient ByteCollection values = null;
    private transient Set<CharacterMap.PrimitiveEntryK<Byte>> entrySetK = null;
    private transient Set<ByteValueMap.PrimitiveEntryV<Character>> entrySetV = null;
    private transient Set<Map.Entry<Character, Byte>> entrySet = null;

    @Override
    public void clear() {
        Iterator<CharacterByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(byte v) {
        for (CharacterByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte f(char k) {
        for (CharacterByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Byte getElement(char k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharacterSet charKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(CharacterByteMap map) {
        for (CharacterByteMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Byte) {
            return this.containsKeyElement(((Character)key).charValue());
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        if (key instanceof Byte) {
            return this.getElement(((Character)key).charValue());
        }
        return null;
    }

    @Override
    public Byte put(Character key, byte value) {
        return this.putElement(key.charValue(), value);
    }

    @Override
    public Byte remove(Object key) {
        if (key instanceof Byte) {
            return this.removeElement(((Character)key).charValue());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Character, ? extends Byte> m) {
        for (Map.Entry<? extends Character, ? extends Byte> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterSet keySet() {
        return this.charKeySet();
    }

    @Override
    public Set<Map.Entry<Character, Byte>> entrySet() {
        final Set<CharacterByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Character, Byte>>(){

                @Override
                public Iterator<Map.Entry<Character, Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Character, Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Character, Byte> next() {
                            final CharacterByteMap.PrimitiveEntry o = (CharacterByteMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Character, Byte>(){

                                @Override
                                public Character getKey() {
                                    return Character.valueOf(o.getKey());
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement((char)k);
    }

    @Override
    public boolean containsKeyElement(char k) {
        for (CharacterByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Byte get(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.getElement((byte)k);
    }

    @Override
    public Byte put(int k, Byte v) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.putElement((char)k, v);
    }

    @Override
    public Byte removeElement(char k) {
        Iterator<CharacterByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            CharacterByteMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            byte r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Byte remove(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.removeElement((char)k);
    }

    @Override
    public Set<CharacterMap.PrimitiveEntryK<Byte>> charKeyEntrySet() {
        final Set<CharacterByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<CharacterMap.PrimitiveEntryK<Byte>>(){

                @Override
                public Iterator<CharacterMap.PrimitiveEntryK<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<CharacterMap.PrimitiveEntryK<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public CharacterMap.PrimitiveEntryK<Byte> next() {
                            final CharacterByteMap.PrimitiveEntry o = (CharacterByteMap.PrimitiveEntry)i.next();
                            return new CharacterMap.PrimitiveEntryK<Byte>(){

                                @Override
                                public char getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Byte putElement(char k, Byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(CharacterMap<Byte> map) {
        for (CharacterMap.PrimitiveEntryK<Byte> e : map.charKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((byte)v);
    }

    @Override
    public Set<ByteValueMap.PrimitiveEntryV<Character>> byteValueEntrySet() {
        final Set<CharacterByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ByteValueMap.PrimitiveEntryV<Character>>(){

                @Override
                public Iterator<ByteValueMap.PrimitiveEntryV<Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteValueMap.PrimitiveEntryV<Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteValueMap.PrimitiveEntryV<Character> next() {
                            final CharacterByteMap.PrimitiveEntry o = (CharacterByteMap.PrimitiveEntry)i.next();
                            return new ByteValueMap.PrimitiveEntryV<Character>(){

                                @Override
                                public Character getKey() {
                                    return Character.valueOf(o.getKey());
                                }

                                @Override
                                public byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public byte setValue(byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public byte getElement(Object k) {
        if (k instanceof Character) {
            return this.f(((Character)k).charValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public byte putElement(Character k, byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteValueMap<Character> map) {
        for (ByteValueMap.PrimitiveEntryV<Character> e : map.byteValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection byteValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Byte) {
            return this.containsValueElement((Byte)value);
        }
        return false;
    }

    @Override
    public Byte put(Character key, Byte value) {
        return this.putElement(key.charValue(), (byte)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (CharacterByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof CharacterByteMap)) break block1;
            m = (CharacterByteMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (CharacterByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractCharacterSet {
        private Set<CharacterByteMap.PrimitiveEntry> eset;

        private KSet(Set<CharacterByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public CharacterIterator charIterator() {
            final Iterator<CharacterByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new CharacterIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public char next() {
                    return ((CharacterByteMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractCharacterByteMap.this.size();
        }

        @Override
        public boolean containsChar(char o) {
            return AbstractCharacterByteMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractCharacterByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractCharacterByteMap.this.clear();
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractByteCollection {
        private Set<CharacterByteMap.PrimitiveEntry> eset;

        private VCol(Set<CharacterByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<CharacterByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public byte next() {
                    return ((CharacterByteMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractCharacterByteMap.this.size();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractCharacterByteMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractCharacterByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractCharacterByteMap.this.clear();
        }
    }
}

