/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.AbstractDoubleSet;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.map.op.ByteValueMap;
import net.morilib.util.primitive.map.po.DoubleMap;
import net.morilib.util.primitive.map.pp.DoubleByteMap;

public abstract class AbstractDoubleByteMap
implements DoubleByteMap {
    private transient DoubleSet keySet = null;
    private transient ByteCollection values = null;
    private transient Set<DoubleMap.PrimitiveEntryK<Byte>> entrySetK = null;
    private transient Set<ByteValueMap.PrimitiveEntryV<Double>> entrySetV = null;
    private transient Set<Map.Entry<Double, Byte>> entrySet = null;

    @Override
    public void clear() {
        Iterator<DoubleByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(byte v) {
        for (DoubleByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte f(double k) {
        for (DoubleByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Byte getElement(double k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet doubleKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(DoubleByteMap map) {
        for (DoubleByteMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Byte) {
            return this.containsKeyElement((Double)key);
        }
        return false;
    }

    @Override
    public Byte get(Object key) {
        if (key instanceof Byte) {
            return this.getElement((Double)key);
        }
        return null;
    }

    @Override
    public Byte put(Double key, byte value) {
        return this.putElement((double)key, value);
    }

    @Override
    public Byte remove(Object key) {
        if (key instanceof Byte) {
            return this.removeElement((Double)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Byte> m) {
        for (Map.Entry<? extends Double, ? extends Byte> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleSet keySet() {
        return this.doubleKeySet();
    }

    @Override
    public Set<Map.Entry<Double, Byte>> entrySet() {
        final Set<DoubleByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Double, Byte>>(){

                @Override
                public Iterator<Map.Entry<Double, Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Double, Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Double, Byte> next() {
                            final DoubleByteMap.PrimitiveEntry o = (DoubleByteMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Double, Byte>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(double k) {
        for (DoubleByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Byte get(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.getElement((byte)k);
    }

    @Override
    public Byte put(int k, Byte v) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.putElement((double)k, v);
    }

    @Override
    public Byte removeElement(double k) {
        Iterator<DoubleByteMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            DoubleByteMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            byte r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Byte remove(int k) {
        if (k < -128 || k > 127) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<DoubleMap.PrimitiveEntryK<Byte>> doubleKeyEntrySet() {
        final Set<DoubleByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<DoubleMap.PrimitiveEntryK<Byte>>(){

                @Override
                public Iterator<DoubleMap.PrimitiveEntryK<Byte>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleMap.PrimitiveEntryK<Byte>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleMap.PrimitiveEntryK<Byte> next() {
                            final DoubleByteMap.PrimitiveEntry o = (DoubleByteMap.PrimitiveEntry)i.next();
                            return new DoubleMap.PrimitiveEntryK<Byte>(){

                                @Override
                                public double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Byte setValue(Byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Byte putElement(double k, Byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleMap<Byte> map) {
        for (DoubleMap.PrimitiveEntryK<Byte> e : map.doubleKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((byte)v);
    }

    @Override
    public Set<ByteValueMap.PrimitiveEntryV<Double>> byteValueEntrySet() {
        final Set<DoubleByteMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ByteValueMap.PrimitiveEntryV<Double>>(){

                @Override
                public Iterator<ByteValueMap.PrimitiveEntryV<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ByteValueMap.PrimitiveEntryV<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ByteValueMap.PrimitiveEntryV<Double> next() {
                            final DoubleByteMap.PrimitiveEntry o = (DoubleByteMap.PrimitiveEntry)i.next();
                            return new ByteValueMap.PrimitiveEntryV<Double>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public byte getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public byte setValue(byte value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public byte getElement(Object k) {
        if (k instanceof Double) {
            return this.f((Double)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public byte putElement(Double k, byte v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ByteValueMap<Double> map) {
        for (ByteValueMap.PrimitiveEntryV<Double> e : map.byteValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ByteCollection byteValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Byte) {
            return this.containsValueElement((Byte)value);
        }
        return false;
    }

    @Override
    public Byte put(Double key, Byte value) {
        return this.putElement((double)key, (byte)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (DoubleByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof DoubleByteMap)) break block1;
            m = (DoubleByteMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (DoubleByteMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractDoubleSet {
        private Set<DoubleByteMap.PrimitiveEntry> eset;

        private KSet(Set<DoubleByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<DoubleByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public double next() {
                    return ((DoubleByteMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleByteMap.this.size();
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractDoubleByteMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleByteMap.this.clear();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractByteCollection {
        private Set<DoubleByteMap.PrimitiveEntry> eset;

        private VCol(Set<DoubleByteMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ByteIterator byteIterator() {
            final Iterator<DoubleByteMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ByteIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public byte next() {
                    return ((DoubleByteMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleByteMap.this.size();
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsByte(byte o) {
            return AbstractDoubleByteMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleByteMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleByteMap.this.clear();
        }
    }
}

