/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleSet;
import net.morilib.util.primitive.AbstractFloatCollection;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.FloatCollection;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.FloatIterator;
import net.morilib.util.primitive.map.op.FloatValueMap;
import net.morilib.util.primitive.map.po.DoubleMap;
import net.morilib.util.primitive.map.pp.DoubleFloatMap;

public abstract class AbstractDoubleFloatMap
implements DoubleFloatMap {
    private transient DoubleSet keySet = null;
    private transient FloatCollection values = null;
    private transient Set<DoubleMap.PrimitiveEntryK<Float>> entrySetK = null;
    private transient Set<FloatValueMap.PrimitiveEntryV<Double>> entrySetV = null;
    private transient Set<Map.Entry<Double, Float>> entrySet = null;

    @Override
    public void clear() {
        Iterator<DoubleFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(float v) {
        for (DoubleFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public float f(double k) {
        for (DoubleFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Float getElement(double k) {
        return Float.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet doubleKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(DoubleFloatMap map) {
        for (DoubleFloatMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Float) {
            return this.containsKeyElement((Double)key);
        }
        return false;
    }

    @Override
    public Float get(Object key) {
        if (key instanceof Float) {
            return this.getElement((Double)key);
        }
        return null;
    }

    @Override
    public Float put(Double key, float value) {
        return this.putElement((double)key, value);
    }

    @Override
    public Float remove(Object key) {
        if (key instanceof Float) {
            return this.removeElement((Double)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Float> m) {
        for (Map.Entry<? extends Double, ? extends Float> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleSet keySet() {
        return this.doubleKeySet();
    }

    @Override
    public Set<Map.Entry<Double, Float>> entrySet() {
        final Set<DoubleFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Double, Float>>(){

                @Override
                public Iterator<Map.Entry<Double, Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Double, Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Double, Float> next() {
                            final DoubleFloatMap.PrimitiveEntry o = (DoubleFloatMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Double, Float>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(double k) {
        for (DoubleFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float get(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement(k);
    }

    @Override
    public Float put(int k, Float v) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((double)k, v);
    }

    @Override
    public Float removeElement(double k) {
        Iterator<DoubleFloatMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            DoubleFloatMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            float r = e.getValue();
            i.remove();
            return Float.valueOf(r);
        }
        return null;
    }

    @Override
    public Float remove(int k) {
        if ((float)k < Float.MIN_VALUE || (float)k > Float.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<DoubleMap.PrimitiveEntryK<Float>> doubleKeyEntrySet() {
        final Set<DoubleFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<DoubleMap.PrimitiveEntryK<Float>>(){

                @Override
                public Iterator<DoubleMap.PrimitiveEntryK<Float>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleMap.PrimitiveEntryK<Float>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleMap.PrimitiveEntryK<Float> next() {
                            final DoubleFloatMap.PrimitiveEntry o = (DoubleFloatMap.PrimitiveEntry)i.next();
                            return new DoubleMap.PrimitiveEntryK<Float>(){

                                @Override
                                public double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Float getValue() {
                                    return Float.valueOf(o.getValue());
                                }

                                @Override
                                public Float setValue(Float value) {
                                    return Float.valueOf(o.setValue(value.floatValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Float putElement(double k, Float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleMap<Float> map) {
        for (DoubleMap.PrimitiveEntryK<Float> e : map.doubleKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<FloatValueMap.PrimitiveEntryV<Double>> floatValueEntrySet() {
        final Set<DoubleFloatMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<FloatValueMap.PrimitiveEntryV<Double>>(){

                @Override
                public Iterator<FloatValueMap.PrimitiveEntryV<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<FloatValueMap.PrimitiveEntryV<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public FloatValueMap.PrimitiveEntryV<Double> next() {
                            final DoubleFloatMap.PrimitiveEntry o = (DoubleFloatMap.PrimitiveEntry)i.next();
                            return new FloatValueMap.PrimitiveEntryV<Double>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public float getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public float setValue(float value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public float getElement(Object k) {
        if (k instanceof Double) {
            return this.f((Double)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public float putElement(Double k, float v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(FloatValueMap<Double> map) {
        for (FloatValueMap.PrimitiveEntryV<Double> e : map.floatValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public FloatCollection floatValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Float) {
            return this.containsValueElement(((Float)value).floatValue());
        }
        return false;
    }

    @Override
    public Float put(Double key, Float value) {
        return this.putElement((double)key, value.floatValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (DoubleFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof DoubleFloatMap)) break block1;
            m = (DoubleFloatMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).floatValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (DoubleFloatMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractDoubleSet {
        private Set<DoubleFloatMap.PrimitiveEntry> eset;

        private KSet(Set<DoubleFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<DoubleFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public double next() {
                    return ((DoubleFloatMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleFloatMap.this.size();
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractDoubleFloatMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleFloatMap.this.clear();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractFloatCollection {
        private Set<DoubleFloatMap.PrimitiveEntry> eset;

        private VCol(Set<DoubleFloatMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public FloatIterator floatIterator() {
            final Iterator<DoubleFloatMap.PrimitiveEntry> ei = this.eset.iterator();
            return new FloatIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public float next() {
                    return ((DoubleFloatMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleFloatMap.this.size();
        }

        @Override
        public boolean addFloat(float v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsFloat(float o) {
            return AbstractDoubleFloatMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleFloatMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleFloatMap.this.clear();
        }
    }
}

