/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractDoubleSet;
import net.morilib.util.primitive.AbstractShortCollection;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.ShortCollection;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.ShortIterator;
import net.morilib.util.primitive.map.op.ShortValueMap;
import net.morilib.util.primitive.map.po.DoubleMap;
import net.morilib.util.primitive.map.pp.DoubleShortMap;

public abstract class AbstractDoubleShortMap
implements DoubleShortMap {
    private transient DoubleSet keySet = null;
    private transient ShortCollection values = null;
    private transient Set<DoubleMap.PrimitiveEntryK<Short>> entrySetK = null;
    private transient Set<ShortValueMap.PrimitiveEntryV<Double>> entrySetV = null;
    private transient Set<Map.Entry<Double, Short>> entrySet = null;

    @Override
    public void clear() {
        Iterator<DoubleShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(short v) {
        for (DoubleShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public short f(double k) {
        for (DoubleShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Short getElement(double k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public DoubleSet doubleKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(DoubleShortMap map) {
        for (DoubleShortMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Short) {
            return this.containsKeyElement((Double)key);
        }
        return false;
    }

    @Override
    public Short get(Object key) {
        if (key instanceof Short) {
            return this.getElement((Double)key);
        }
        return null;
    }

    @Override
    public Short put(Double key, short value) {
        return this.putElement((double)key, value);
    }

    @Override
    public Short remove(Object key) {
        if (key instanceof Short) {
            return this.removeElement((Double)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Short> m) {
        for (Map.Entry<? extends Double, ? extends Short> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public DoubleSet keySet() {
        return this.doubleKeySet();
    }

    @Override
    public Set<Map.Entry<Double, Short>> entrySet() {
        final Set<DoubleShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Double, Short>>(){

                @Override
                public Iterator<Map.Entry<Double, Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Double, Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Double, Short> next() {
                            final DoubleShortMap.PrimitiveEntry o = (DoubleShortMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Double, Short>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if ((double)k < Double.MIN_VALUE || (double)k > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(double k) {
        for (DoubleShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Short get(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((short)k);
    }

    @Override
    public Short put(int k, Short v) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement((double)k, v);
    }

    @Override
    public Short removeElement(double k) {
        Iterator<DoubleShortMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            DoubleShortMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            short r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Short remove(int k) {
        if (k < Short.MIN_VALUE || k > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<DoubleMap.PrimitiveEntryK<Short>> doubleKeyEntrySet() {
        final Set<DoubleShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<DoubleMap.PrimitiveEntryK<Short>>(){

                @Override
                public Iterator<DoubleMap.PrimitiveEntryK<Short>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<DoubleMap.PrimitiveEntryK<Short>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public DoubleMap.PrimitiveEntryK<Short> next() {
                            final DoubleShortMap.PrimitiveEntry o = (DoubleShortMap.PrimitiveEntry)i.next();
                            return new DoubleMap.PrimitiveEntryK<Short>(){

                                @Override
                                public double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Short setValue(Short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Short putElement(double k, Short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(DoubleMap<Short> map) {
        for (DoubleMap.PrimitiveEntryK<Short> e : map.doubleKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if ((double)v < Double.MIN_VALUE || (double)v > Double.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((short)v);
    }

    @Override
    public Set<ShortValueMap.PrimitiveEntryV<Double>> shortValueEntrySet() {
        final Set<DoubleShortMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<ShortValueMap.PrimitiveEntryV<Double>>(){

                @Override
                public Iterator<ShortValueMap.PrimitiveEntryV<Double>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<ShortValueMap.PrimitiveEntryV<Double>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public ShortValueMap.PrimitiveEntryV<Double> next() {
                            final DoubleShortMap.PrimitiveEntry o = (DoubleShortMap.PrimitiveEntry)i.next();
                            return new ShortValueMap.PrimitiveEntryV<Double>(){

                                @Override
                                public Double getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public short getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public short setValue(short value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public short getElement(Object k) {
        if (k instanceof Double) {
            return this.f((Double)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public short putElement(Double k, short v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(ShortValueMap<Double> map) {
        for (ShortValueMap.PrimitiveEntryV<Double> e : map.shortValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public ShortCollection shortValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Short) {
            return this.containsValueElement((Short)value);
        }
        return false;
    }

    @Override
    public Short put(Double key, Short value) {
        return this.putElement((double)key, (short)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (DoubleShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof DoubleShortMap)) break block1;
            m = (DoubleShortMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (DoubleShortMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractDoubleSet {
        private Set<DoubleShortMap.PrimitiveEntry> eset;

        private KSet(Set<DoubleShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public DoubleIterator doubleIterator() {
            final Iterator<DoubleShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new DoubleIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public double next() {
                    return ((DoubleShortMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleShortMap.this.size();
        }

        @Override
        public boolean containsDouble(double o) {
            return AbstractDoubleShortMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleShortMap.this.clear();
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractShortCollection {
        private Set<DoubleShortMap.PrimitiveEntry> eset;

        private VCol(Set<DoubleShortMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public ShortIterator shortIterator() {
            final Iterator<DoubleShortMap.PrimitiveEntry> ei = this.eset.iterator();
            return new ShortIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public short next() {
                    return ((DoubleShortMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractDoubleShortMap.this.size();
        }

        @Override
        public boolean addShort(short v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsShort(short o) {
            return AbstractDoubleShortMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractDoubleShortMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractDoubleShortMap.this.clear();
        }
    }
}

