/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractCharacterCollection;
import net.morilib.util.primitive.AbstractIntegerSet;
import net.morilib.util.primitive.CharacterCollection;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.iterator.CharacterIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.map.op.CharacterValueMap;
import net.morilib.util.primitive.map.po.IntegerMap;
import net.morilib.util.primitive.map.pp.IntegerCharacterMap;

public abstract class AbstractIntegerCharacterMap
implements IntegerCharacterMap {
    private transient IntegerSet keySet = null;
    private transient CharacterCollection values = null;
    private transient Set<IntegerMap.PrimitiveEntryK<Character>> entrySetK = null;
    private transient Set<CharacterValueMap.PrimitiveEntryV<Integer>> entrySetV = null;
    private transient Set<Map.Entry<Integer, Character>> entrySet = null;

    @Override
    public void clear() {
        Iterator<IntegerCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(char v) {
        for (IntegerCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public char f(int k) {
        for (IntegerCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Character getElement(int k) {
        return Character.valueOf(this.f(k));
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntegerSet intKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(IntegerCharacterMap map) {
        for (IntegerCharacterMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Character) {
            return this.containsKeyElement((Integer)key);
        }
        return false;
    }

    @Override
    public Character get(Object key) {
        if (key instanceof Character) {
            return this.getElement((Integer)key);
        }
        return null;
    }

    @Override
    public Character put(Integer key, char value) {
        return this.putElement((int)key, value);
    }

    @Override
    public Character remove(Object key) {
        if (key instanceof Character) {
            return this.removeElement((Integer)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Character> m) {
        for (Map.Entry<? extends Integer, ? extends Character> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerSet keySet() {
        return this.intKeySet();
    }

    @Override
    public Set<Map.Entry<Integer, Character>> entrySet() {
        final Set<IntegerCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, Character>>(){

                @Override
                public Iterator<Map.Entry<Integer, Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Integer, Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Integer, Character> next() {
                            final IntegerCharacterMap.PrimitiveEntry o = (IntegerCharacterMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Integer, Character>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(int k) {
        for (IntegerCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Character get(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.getElement((char)k);
    }

    @Override
    public Character put(int k, Character v) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public Character removeElement(int k) {
        Iterator<IntegerCharacterMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            IntegerCharacterMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            char r = e.getValue();
            i.remove();
            return Character.valueOf(r);
        }
        return null;
    }

    @Override
    public Character remove(int k) {
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<IntegerMap.PrimitiveEntryK<Character>> intKeyEntrySet() {
        final Set<IntegerCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<IntegerMap.PrimitiveEntryK<Character>>(){

                @Override
                public Iterator<IntegerMap.PrimitiveEntryK<Character>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerMap.PrimitiveEntryK<Character>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerMap.PrimitiveEntryK<Character> next() {
                            final IntegerCharacterMap.PrimitiveEntry o = (IntegerCharacterMap.PrimitiveEntry)i.next();
                            return new IntegerMap.PrimitiveEntryK<Character>(){

                                @Override
                                public int getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Character getValue() {
                                    return Character.valueOf(o.getValue());
                                }

                                @Override
                                public Character setValue(Character value) {
                                    return Character.valueOf(o.setValue(value.charValue()));
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Character putElement(int k, Character v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerMap<Character> map) {
        for (IntegerMap.PrimitiveEntryK<Character> e : map.intKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement((char)v);
    }

    @Override
    public Set<CharacterValueMap.PrimitiveEntryV<Integer>> charValueEntrySet() {
        final Set<IntegerCharacterMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<CharacterValueMap.PrimitiveEntryV<Integer>>(){

                @Override
                public Iterator<CharacterValueMap.PrimitiveEntryV<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<CharacterValueMap.PrimitiveEntryV<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public CharacterValueMap.PrimitiveEntryV<Integer> next() {
                            final IntegerCharacterMap.PrimitiveEntry o = (IntegerCharacterMap.PrimitiveEntry)i.next();
                            return new CharacterValueMap.PrimitiveEntryV<Integer>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public char getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public char setValue(char value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public char getElement(Object k) {
        if (k instanceof Integer) {
            return this.f((Integer)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public char putElement(Integer k, char v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(CharacterValueMap<Integer> map) {
        for (CharacterValueMap.PrimitiveEntryV<Integer> e : map.charValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public CharacterCollection charValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Character) {
            return this.containsValueElement(((Character)value).charValue());
        }
        return false;
    }

    @Override
    public Character put(Integer key, Character value) {
        return this.putElement((int)key, value.charValue());
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (IntegerCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof IntegerCharacterMap)) break block1;
            m = (IntegerCharacterMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey()).charValue();
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (IntegerCharacterMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractIntegerSet {
        private Set<IntegerCharacterMap.PrimitiveEntry> eset;

        private KSet(Set<IntegerCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<IntegerCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public int next() {
                    return ((IntegerCharacterMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerCharacterMap.this.size();
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractIntegerCharacterMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerCharacterMap.this.clear();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractCharacterCollection {
        private Set<IntegerCharacterMap.PrimitiveEntry> eset;

        private VCol(Set<IntegerCharacterMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public CharacterIterator charIterator() {
            final Iterator<IntegerCharacterMap.PrimitiveEntry> ei = this.eset.iterator();
            return new CharacterIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public char next() {
                    return ((IntegerCharacterMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerCharacterMap.this.size();
        }

        @Override
        public boolean addChar(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsChar(char o) {
            return AbstractIntegerCharacterMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerCharacterMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerCharacterMap.this.clear();
        }
    }
}

