/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive.map.pp;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.primitive.AbstractIntegerSet;
import net.morilib.util.primitive.AbstractLongCollection;
import net.morilib.util.primitive.IntegerSet;
import net.morilib.util.primitive.LongCollection;
import net.morilib.util.primitive.iterator.IntegerIterator;
import net.morilib.util.primitive.iterator.LongIterator;
import net.morilib.util.primitive.map.op.LongValueMap;
import net.morilib.util.primitive.map.po.IntegerMap;
import net.morilib.util.primitive.map.pp.IntegerLongMap;

public abstract class AbstractIntegerLongMap
implements IntegerLongMap {
    private transient IntegerSet keySet = null;
    private transient LongCollection values = null;
    private transient Set<IntegerMap.PrimitiveEntryK<Long>> entrySetK = null;
    private transient Set<LongValueMap.PrimitiveEntryV<Integer>> entrySetV = null;
    private transient Set<Map.Entry<Integer, Long>> entrySet = null;

    @Override
    public void clear() {
        Iterator<IntegerLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean containsValueElement(long v) {
        for (IntegerLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public long f(int k) {
        for (IntegerLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return e.getValue();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Long getElement(int k) {
        return this.f(k);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntegerSet intKeySet() {
        return this.keySet == null ? (this.keySet = new KSet(this.primitiveEntrySet())) : this.keySet;
    }

    @Override
    public void putAllElement(IntegerLongMap map) {
        for (IntegerLongMap.PrimitiveEntry e : map.primitiveEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection values() {
        return this.values == null ? (this.values = new VCol(this.primitiveEntrySet())) : this.values;
    }

    @Override
    public boolean isTotal() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Long) {
            return this.containsKeyElement((Integer)key);
        }
        return false;
    }

    @Override
    public Long get(Object key) {
        if (key instanceof Long) {
            return this.getElement((Integer)key);
        }
        return null;
    }

    @Override
    public Long put(Integer key, long value) {
        return this.putElement((int)key, value);
    }

    @Override
    public Long remove(Object key) {
        if (key instanceof Long) {
            return this.removeElement((Integer)key);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Long> m) {
        for (Map.Entry<? extends Integer, ? extends Long> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public IntegerSet keySet() {
        return this.intKeySet();
    }

    @Override
    public Set<Map.Entry<Integer, Long>> entrySet() {
        final Set<IntegerLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<Integer, Long>>(){

                @Override
                public Iterator<Map.Entry<Integer, Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<Map.Entry<Integer, Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public Map.Entry<Integer, Long> next() {
                            final IntegerLongMap.PrimitiveEntry o = (IntegerLongMap.PrimitiveEntry)i.next();
                            return new Map.Entry<Integer, Long>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean containsKey(int k) {
        if (k < Integer.MIN_VALUE || k > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsKeyElement(k);
    }

    @Override
    public boolean containsKeyElement(int k) {
        for (IntegerLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            if (e.getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public Long get(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.getElement((Object)k);
    }

    @Override
    public Long put(int k, Long v) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.putElement(k, v);
    }

    @Override
    public Long removeElement(int k) {
        Iterator<IntegerLongMap.PrimitiveEntry> i = this.primitiveEntrySet().iterator();
        while (i.hasNext()) {
            IntegerLongMap.PrimitiveEntry e = i.next();
            if (e.getKey() != k) continue;
            long r = e.getValue();
            i.remove();
            return r;
        }
        return null;
    }

    @Override
    public Long remove(int k) {
        if ((long)k < Long.MIN_VALUE || (long)k > Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.removeElement(k);
    }

    @Override
    public Set<IntegerMap.PrimitiveEntryK<Long>> intKeyEntrySet() {
        final Set<IntegerLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetK == null) {
            this.entrySetK = new AbstractSet<IntegerMap.PrimitiveEntryK<Long>>(){

                @Override
                public Iterator<IntegerMap.PrimitiveEntryK<Long>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<IntegerMap.PrimitiveEntryK<Long>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public IntegerMap.PrimitiveEntryK<Long> next() {
                            final IntegerLongMap.PrimitiveEntry o = (IntegerLongMap.PrimitiveEntry)i.next();
                            return new IntegerMap.PrimitiveEntryK<Long>(){

                                @Override
                                public int getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public Long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public Long setValue(Long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetK;
    }

    @Override
    public Long putElement(int k, Long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(IntegerMap<Long> map) {
        for (IntegerMap.PrimitiveEntryK<Long> e : map.intKeyEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(int v) {
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.containsValueElement(v);
    }

    @Override
    public Set<LongValueMap.PrimitiveEntryV<Integer>> longValueEntrySet() {
        final Set<IntegerLongMap.PrimitiveEntry> e = this.primitiveEntrySet();
        if (this.entrySetV == null) {
            this.entrySetV = new AbstractSet<LongValueMap.PrimitiveEntryV<Integer>>(){

                @Override
                public Iterator<LongValueMap.PrimitiveEntryV<Integer>> iterator() {
                    final Iterator i = e.iterator();
                    return new Iterator<LongValueMap.PrimitiveEntryV<Integer>>(){

                        @Override
                        public boolean hasNext() {
                            return i.hasNext();
                        }

                        @Override
                        public LongValueMap.PrimitiveEntryV<Integer> next() {
                            final IntegerLongMap.PrimitiveEntry o = (IntegerLongMap.PrimitiveEntry)i.next();
                            return new LongValueMap.PrimitiveEntryV<Integer>(){

                                @Override
                                public Integer getKey() {
                                    return o.getKey();
                                }

                                @Override
                                public long getValue() {
                                    return o.getValue();
                                }

                                @Override
                                public long setValue(long value) {
                                    return o.setValue(value);
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return e.size();
                }
            };
        }
        return this.entrySetV;
    }

    @Override
    public long getElement(Object k) {
        if (k instanceof Integer) {
            return this.f((Integer)k);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long putElement(Integer k, long v) {
        return this.putElement(k, v);
    }

    @Override
    public void putAllElement(LongValueMap<Integer> map) {
        for (LongValueMap.PrimitiveEntryV<Integer> e : map.longValueEntrySet()) {
            this.putElement(e.getKey(), e.getValue());
        }
    }

    @Override
    public LongCollection longValues() {
        return this.values();
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Long) {
            return this.containsValueElement((Long)value);
        }
        return false;
    }

    @Override
    public Long put(Integer key, Long value) {
        return this.putElement((int)key, (long)value);
    }

    @Override
    public int hashCode() {
        int r = 0;
        for (IntegerLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            r += e.hashCode();
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean equals(Object obj) {
        block1: {
            if (!(obj instanceof IntegerLongMap)) break block1;
            m = (IntegerLongMap)obj;
            i = this.primitiveEntrySet().iterator();
            if (this.size() == m.size()) ** GOTO lbl11
            return false;
lbl-1000:
            // 1 sources

            {
                o = i.next();
                v = m.getElement(o.getKey());
                p = o.getValue();
                if (m.containsKeyElement(o.getKey()) && v == p) continue;
                return false;
lbl11:
                // 2 sources

                ** while (i.hasNext())
            }
lbl12:
            // 1 sources

            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("{");
        for (IntegerLongMap.PrimitiveEntry e : this.primitiveEntrySet()) {
            b.append(d);
            b.append(e);
            d = ", ";
        }
        b.append("}");
        return b.toString();
    }

    private class KSet
    extends AbstractIntegerSet {
        private Set<IntegerLongMap.PrimitiveEntry> eset;

        private KSet(Set<IntegerLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public IntegerIterator intIterator() {
            final Iterator<IntegerLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new IntegerIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public int next() {
                    return ((IntegerLongMap.PrimitiveEntry)ei.next()).getKey();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerLongMap.this.size();
        }

        @Override
        public boolean containsInt(int o) {
            return AbstractIntegerLongMap.this.containsKeyElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerLongMap.this.clear();
        }

        @Override
        public boolean addInt(int v) {
            throw new UnsupportedOperationException();
        }
    }

    private class VCol
    extends AbstractLongCollection {
        private Set<IntegerLongMap.PrimitiveEntry> eset;

        private VCol(Set<IntegerLongMap.PrimitiveEntry> eset) {
            this.eset = eset;
        }

        @Override
        public LongIterator longIterator() {
            final Iterator<IntegerLongMap.PrimitiveEntry> ei = this.eset.iterator();
            return new LongIterator(){

                @Override
                public boolean hasNext() {
                    return ei.hasNext();
                }

                @Override
                public long next() {
                    return ((IntegerLongMap.PrimitiveEntry)ei.next()).getValue();
                }

                @Override
                public void remove() {
                    ei.remove();
                }
            };
        }

        @Override
        public int size() {
            return AbstractIntegerLongMap.this.size();
        }

        @Override
        public boolean addLong(long v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInfinite() {
            return false;
        }

        @Override
        public boolean containsLong(long o) {
            return AbstractIntegerLongMap.this.containsValueElement(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractIntegerLongMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            AbstractIntegerLongMap.this.clear();
        }
    }
}

