/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set.quotient;

import java.util.Collection;
import net.morilib.lang.Equivalence;
import net.morilib.util.SimpleMap;
import net.morilib.util.collection.MappedCollection;
import net.morilib.util.datafactory.SetFactory;
import net.morilib.util.set.AbstractDecoratedSet;
import net.morilib.util.set.quotient.QuotientSet;

public class DecoratedQuotientSet<E, Q>
extends AbstractDecoratedSet<Q>
implements QuotientSet<E, Q> {
    protected Equivalence<E, Q> equivalence;

    protected DecoratedQuotientSet(SetFactory factory, Equivalence<E, Q> equivalence) {
        super(factory.newInstance());
        this.equivalence = equivalence;
    }

    @Override
    public boolean containsClass(E o) {
        return this.contains(this.equivalence.classify(o));
    }

    @Override
    public boolean addClass(E e) {
        return this.add(this.equivalence.classify(e));
    }

    @Override
    public boolean containsAllClass(Collection<? extends E> c) {
        return this.containsAll(new MappedCollection(c, new SimpleMap<E, Object>(){

            @Override
            public Object map(E e) {
                return DecoratedQuotientSet.this.equivalence.classify(e);
            }
        }));
    }

    @Override
    public boolean addAllClass(Collection<? extends E> c) {
        return this.addAll(new MappedCollection(c, new SimpleMap<E, Q>(){

            @Override
            public Q map(E e) {
                return DecoratedQuotientSet.this.equivalence.classify(e);
            }
        }));
    }
}

