/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.table;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.morilib.util.Iterators;
import net.morilib.util.table.AbstractTable;
import net.morilib.util.table.Table;

public final class Tables {
    public static final Table<Object> EMPTY = new _Empty();

    public static <E> Table<E> emptyTable() {
        return EMPTY;
    }

    public static <E> Table<E> unmodifiable(Table<E> t) {
        return new _Unmodifiable(t);
    }

    static class Pos {
        private int x;
        private int y;

        Pos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (o instanceof Pos) {
                Pos p = (Pos)o;
                return this.x == p.x && this.y == p.y;
            }
            return false;
        }

        public int hashCode() {
            int res = 17;
            res = 37 * res + this.x;
            res = 37 * res + this.y;
            return res;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }

    static abstract class ReadOnlyTable<E>
    extends AbstractTable<E> {
        ReadOnlyTable() {
        }

        @Override
        public E set(int r, int c, E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setRow(int row, List<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setRow(int row, List<E> list, int cbgn, int cend) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int addRow(int row, List<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int addRow(List<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteRow(int row) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setColumn(int col, List<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int setColumn(int col, List<E> list, int rbgn, int rend) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int addColumn(int col, List<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int addColumn(List<E> list) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deleteColumn(int col) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void addColumn(int col) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void addRow(int row) {
            throw new UnsupportedOperationException();
        }
    }

    private static class _Empty
    extends ReadOnlyTable<Object>
    implements Serializable {
        private static final long serialVersionUID = 2098001818079704026L;

        private _Empty() {
        }

        @Override
        public Object get(int r, int c) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int rowSize() {
            return 0;
        }

        @Override
        public int columnSize() {
            return 0;
        }

        @Override
        public Iterator<Object> wholeIterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Iterator<Object> rowIterator(int row) {
            return Iterators.emptyIterator();
        }

        @Override
        public Iterator<Object> columnIterator(int column) {
            return Iterators.emptyIterator();
        }

        @Override
        public Table<Object> subTable(int r1, int c1, int r2, int c2) {
            if (r1 == 0 && c1 == 0 && r2 == 0 && c2 == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static class _Unmodifiable<E>
    extends ReadOnlyTable<E>
    implements Serializable {
        private static final long serialVersionUID = 7048452960324140160L;
        private Table<E> w;

        private _Unmodifiable(Table<E> w) {
            this.w = w;
        }

        @Override
        public E get(int r, int c) {
            return this.w.get(r, c);
        }

        @Override
        public int rowSize() {
            return this.w.rowSize();
        }

        @Override
        public int columnSize() {
            return this.w.columnSize();
        }

        @Override
        public Iterator<E> wholeIterator() {
            return this.w.wholeIterator();
        }

        @Override
        public Iterator<E> rowIterator(int row) {
            return this.w.rowIterator(row);
        }

        @Override
        public Iterator<E> columnIterator(int column) {
            return this.w.columnIterator(column);
        }

        @Override
        public Table<E> subTable(int r1, int r2, int c1, int c2) {
            Table<E> res = this.w.subTable(r1, r2, c1, c2);
            return new _Unmodifiable<E>(res);
        }
    }
}

