/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.tape;

import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.primitive.IntegerVector;
import net.morilib.util.tape.CharTape;

public class MarkableReadOnlyCharTape
implements CharTape {
    private CharTape tape;
    private IntegerVector buf = null;
    private int ptr = -1;
    private int ptrall = 0;
    private boolean reachRightEdge = false;

    public MarkableReadOnlyCharTape(CharTape tape) {
        this.tape = tape;
    }

    @Override
    public Integer read() {
        return this.readc();
    }

    @Override
    public boolean write(Integer symbol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean moveRight() {
        if (this.reachRightEdge) {
            return false;
        }
        if (this.ptr < 0) {
            int c = (Integer)this.tape.read();
            if (!this.tape.moveRight()) {
                this.reachRightEdge = true;
                ++this.ptrall;
                return false;
            }
            if (this.buf != null) {
                this.buf.add(c);
            }
        } else if (++this.ptr >= this.buf.size()) {
            this.tape.moveRight();
            this.ptr = -1;
        }
        ++this.ptrall;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean moveLeft() {
        if (this.reachRightEdge) {
            this.reachRightEdge = false;
        }
        if (this.ptr < 0) {
            if (this.buf == null) return false;
            this.ptr = this.buf.size() - 1;
        } else if (--this.ptr < 0) {
            this.ptr = 0;
            return false;
        }
        --this.ptrall;
        return true;
    }

    @Override
    public int mark() {
        this.buf = new IntegerArrayVector();
        this.ptr = -1;
        return this.ptrall;
    }

    @Override
    public int back() {
        if (this.buf != null) {
            this.ptrall -= this.buf.size() - 1 - (this.ptr < 0 ? 0 : this.ptr);
            if (this.reachRightEdge) {
                --this.ptrall;
            }
            this.ptr = 0;
        }
        return this.ptrall;
    }

    @Override
    public int readc() {
        if (this.ptr < 0 || this.ptr >= this.buf.size()) {
            int c = this.tape.readc();
            if (c >= 0) {
                this.buf.add(c);
                return c;
            }
            this.reachRightEdge = true;
            return -1;
        }
        return this.ptr < 0 ? this.tape.readc() : this.buf.getInt(this.ptr);
    }

    @Override
    public boolean writec(int c) {
        throw new UnsupportedOperationException();
    }
}

