/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import java.io.Serializable;
import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.util.Arrays2;
import net.morilib.util.Bytes;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.ByteMemory;
import net.morilib.util.uvector.Endianness;
import net.morilib.util.uvector.UniformArray;

public class ByteArray
extends AbstractUniformArray
implements ByteMemory,
Serializable {
    private byte[] array;
    private UniformArray.TypeAttr signed;

    private ByteArray(byte[] arr, UniformArray.TypeAttr attr) {
        if (!attr.isExact()) {
            throw new IllegalArgumentException(attr.toString());
        }
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = Arrays2.copy(arr);
        this.signed = attr;
    }

    public ByteArray(ByteArray a) {
        this.array = Arrays2.copy(a.array);
        this.signed = a.signed;
    }

    public static ByteArray newArray(byte[] arr) {
        return new ByteArray(arr, UniformArray.TypeAttr.SIGNED_INT);
    }

    public static ByteArray newuArray(byte[] arr) {
        return new ByteArray(arr, UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public static ByteArray malloc(int size) {
        return new ByteArray(new byte[size], UniformArray.TypeAttr.SIGNED_INT);
    }

    public static ByteArray mallocu(int size) {
        return new ByteArray(new byte[size], UniformArray.TypeAttr.UNSIGNED_INT);
    }

    @Override
    public byte getByte(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    @Override
    public double getDouble(int i) {
        return this.getInt(i);
    }

    @Override
    public float getFloat(int i) {
        return this.getInt(i);
    }

    @Override
    public int getInt(int i) {
        int r = this.getByte(i);
        int s = this.signed.isSigned() ? r : Bytes.ubyteToInt((byte)r);
        return s;
    }

    @Override
    public long getLong(int i) {
        return this.getInt(i);
    }

    @Override
    public short getShort(int i) {
        return (short)this.getInt(i);
    }

    @Override
    public void setByte(int i, byte x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    @Override
    public void setDouble(int i, double x) {
        this.setInt(i, (int)x);
    }

    @Override
    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    @Override
    public void setInt(int i, int x) {
        this.setByte(i, (byte)x);
    }

    @Override
    public void setLong(int i, long x) {
        this.setByte(i, (byte)x);
    }

    @Override
    public void setShort(int i, short x) {
        this.setByte(i, (byte)x);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public byte readByte(int i) {
        return this.getByte(i);
    }

    @Override
    public double readDouble(int i, Endianness e) {
        return Double.longBitsToDouble(this.readLong(i, e));
    }

    @Override
    public float readFloat(int i, Endianness e) {
        return Float.intBitsToFloat(this.readInt(i, e));
    }

    @Override
    public int readInt(int i, Endianness e) {
        return e.readInt(this.array, i);
    }

    @Override
    public long readLong(int i, Endianness e) {
        return e.readLong(this.array, i);
    }

    @Override
    public short readShort(int i, Endianness e) {
        return (short)this.readuShort(i, e);
    }

    @Override
    public void writeByte(int i, byte x) {
        this.setByte(i, x);
    }

    @Override
    public void writeDouble(int i, double x, Endianness e) {
        this.writeLong(i, Double.doubleToLongBits(x), e);
    }

    @Override
    public void writeFloat(int i, float x, Endianness e) {
        this.writeInt(i, Float.floatToIntBits(x), e);
    }

    @Override
    public void writeInt(int i, int x, Endianness e) {
        e.writeInt(this.array, i, x);
    }

    @Override
    public void writeLong(int i, long x, Endianness e) {
        e.writeLong(this.array, i, x);
    }

    @Override
    public void writeShort(int i, short x, Endianness e) {
        e.writeShort(this.array, i, x);
    }

    @Override
    public int readuByte(int i) {
        return Bytes.ubyteToInt(this.readByte(i));
    }

    @Override
    public long readuInt(int i, Endianness e) {
        return e.readuInt(this.array, i);
    }

    @Override
    public int readuShort(int i, Endianness e) {
        return e.readuShort(this.array, i);
    }

    @Override
    public void writeuByte(int i, int x) {
        this.writeByte(i, (byte)x);
    }

    @Override
    public void writeuInt(int i, long x, Endianness e) {
        e.writeuInt(this.array, i, x);
    }

    @Override
    public void writeuShort(int i, int x, Endianness e) {
        e.writeuShort(this.array, i, x);
    }

    @Override
    public double readDoubleB(int i) {
        return this.readDouble(i, Endianness.BIG);
    }

    @Override
    public double readDoubleL(int i) {
        return this.readDouble(i, Endianness.LITTLE);
    }

    @Override
    public float readFloatB(int i) {
        return this.readFloat(i, Endianness.BIG);
    }

    @Override
    public float readFloatL(int i) {
        return this.readFloat(i, Endianness.LITTLE);
    }

    @Override
    public int readIntB(int i) {
        return this.readInt(i, Endianness.BIG);
    }

    @Override
    public int readIntL(int i) {
        return this.readInt(i, Endianness.LITTLE);
    }

    @Override
    public long readLongB(int i) {
        return this.readLong(i, Endianness.BIG);
    }

    @Override
    public long readLongL(int i) {
        return this.readLong(i, Endianness.LITTLE);
    }

    @Override
    public short readShortB(int i) {
        return this.readShort(i, Endianness.BIG);
    }

    @Override
    public short readShortL(int i) {
        return this.readShort(i, Endianness.LITTLE);
    }

    @Override
    public long readuIntB(int i) {
        return this.readuInt(i, Endianness.BIG);
    }

    @Override
    public long readuIntL(int i) {
        return this.readuInt(i, Endianness.LITTLE);
    }

    @Override
    public int readuShortB(int i) {
        return this.readuShort(i, Endianness.BIG);
    }

    @Override
    public int readuShortL(int i) {
        return this.readuShort(i, Endianness.LITTLE);
    }

    @Override
    public void writeDoubleB(int i, double x) {
        this.writeDouble(i, x, Endianness.BIG);
    }

    @Override
    public void writeDoubleL(int i, double x) {
        this.writeDouble(i, x, Endianness.LITTLE);
    }

    @Override
    public void writeFloatB(int i, float x) {
        this.writeFloat(i, x, Endianness.BIG);
    }

    @Override
    public void writeFloatL(int i, float x) {
        this.writeFloat(i, x, Endianness.LITTLE);
    }

    @Override
    public void writeIntB(int i, int x) {
        this.writeInt(i, x, Endianness.BIG);
    }

    @Override
    public void writeIntL(int i, int x) {
        this.writeInt(i, x, Endianness.LITTLE);
    }

    @Override
    public void writeLongB(int i, long x) {
        this.writeLong(i, x, Endianness.BIG);
    }

    @Override
    public void writeLongL(int i, long x) {
        this.writeLong(i, x, Endianness.LITTLE);
    }

    @Override
    public void writeShortB(int i, short x) {
        this.writeShort(i, x, Endianness.BIG);
    }

    @Override
    public void writeShortL(int i, short x) {
        this.writeShort(i, x, Endianness.LITTLE);
    }

    @Override
    public void writeuIntB(int i, long x) {
        this.writeuInt(i, x, Endianness.BIG);
    }

    @Override
    public void writeuIntL(int i, long x) {
        this.writeuInt(i, x, Endianness.LITTLE);
    }

    @Override
    public void writeuShortB(int i, int x) {
        this.writeuShort(i, x, Endianness.BIG);
    }

    @Override
    public void writeuShortL(int i, int x) {
        this.writeuShort(i, x, Endianness.LITTLE);
    }

    @Override
    public byte[] toByteArray() {
        return Arrays2.copy(this.array);
    }

    @Override
    public byte[] toByteArray(Endianness e) {
        return this.toByteArray();
    }

    public void arraycopy(int sd, ByteArray s, int ss, int l) {
        System.arraycopy(s.array, ss, this.array, sd, l);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteArray) {
            return Arrays.equals(this.array, ((ByteArray)obj).array);
        }
        return false;
    }
}

