/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import net.morilib.lisp.condition.LispCondition;
import net.morilib.lisp.condition.LispSimpleCondition;

public class LispIOException extends LispException {

	//
	private static final long serialVersionUID = 1301469439708033365L;
	private static final String IO_CODE = "err.io";

	/**
	 * 
	 */
	public LispIOException() {
		super(IO_CODE);
	}

	/**
	 * @param message
	 * @param cause
	 */
	public LispIOException(String message, Throwable cause) {
		super(IO_CODE, message, makecond(message), cause);
	}

	/**
	 * @param message
	 */
	public LispIOException(String message) {
		super(IO_CODE, message, makecond(message));
	}

	/**
	 * @param cause
	 */
	public LispIOException(Throwable cause) {
		super(IO_CODE, makecond(), cause);
	}

	//
	private static LispCondition makecond() {
		LispSimpleCondition err;

		err = LispSimpleCondition.newInstance("&error");
		return err;
	}

	//
	private static LispCondition makecond(String message) {
		LispSimpleCondition err, msg;

		err = LispSimpleCondition.newInstance("&error");
		msg = LispSimpleCondition.newInstance("&message");
		msg.setField("message", new LispString(message));
		return err;
	}

}
