/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.net.syslog;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/01/18
 */
public class SyslogPRI {

	//
	private SyslogFacility facility;
	private SyslogLevel level;

	/**
	 * 
	 * @param facility
	 * @param level
	 */
	public SyslogPRI(SyslogFacility facility,
			SyslogLevel level) {
		this.facility = facility;
		this.level = level;
	}

	/**
	 * 
	 * @return
	 */
	public SyslogFacility getFacility() {
		return facility;
	}

	/**
	 * 
	 * @return
	 */
	public SyslogLevel getLevel() {
		return level;
	}

	/**
	 * 
	 * @return
	 */
	public int getPriorityCode() {
		return facility.getCode() * 8 + level.getCode();
	}

	/**
	 * 
	 * @return
	 */
	public String toSyslogPriority() {
		return "<" + getPriorityCode() + ">";
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return getPriorityCode();
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if(o instanceof SyslogPRI) {
			SyslogPRI s = (SyslogPRI)o;

			return (facility.equals(s.facility) &&
					level.equals(s.level));
		}
		return false;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return facility.toString() + "," + level.toString();
	}

}
