/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2005 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include "intl.h"
#include "scim_tomoe_prefs_win.h"
#include "scim_tomoe_prefs.h"
#include "tomoe_window.h"
#include "tomoe_canvas.h"

enum {
    HOGE_SIGNAL,
    LAST_SIGNAL,
};

#define OBJECT_DATA_CONFIG_KEY        "ScimTomoePrefsWin::ConfigKey"
#define OBJECT_DATA_CONFIG_VALUE      "ScimTomoePrefsWin::ConfigValue"

static void scim_tomoe_prefs_win_class_init  (ScimTomoePrefsWinClass *klass);
static void scim_tomoe_prefs_win_init        (ScimTomoePrefsWin      *prefs_win);
static void scim_tomoe_prefs_win_dispose     (GObject                *object);

static void load_config                      (ScimTomoePrefsWin      *prefs_win);
static void apply_config                     (ScimTomoePrefsWin      *prefs_win);

static void on_default_toggle_button_toggled (GtkToggleButton        *togglebutton,
                                              gpointer                user_data);
static void on_default_toggle_button_set_sensitive
                                             (GtkToggleButton        *togglebutton,
                                              gpointer                user_data);
static void on_default_spin_button_changed   (GtkSpinButton          *spinbutton,
                                              gpointer                user_data);

//static guint prefs_win_signals[LAST_SIGNAL] = { 0 };
static GtkDialogClass *parent_class = NULL;

GType
scim_tomoe_prefs_win_get_type (void)
{
    static GType type = 0;

    if (!type) {
        static const GTypeInfo info = {
            sizeof (ScimTomoePrefsWinClass),
            NULL,           /* base_init */
            NULL,           /* base_finalize */
            (GClassInitFunc) scim_tomoe_prefs_win_class_init,
            NULL,           /* class_finalize */
            NULL,           /* class_data */
            sizeof (ScimTomoePrefsWin),
            0,              /* n_preallocs */
            (GInstanceInitFunc) scim_tomoe_prefs_win_init,
        };

        type = g_type_register_static (GTK_TYPE_DIALOG,
                                       "ScimTomoePrefsWin",
                                       &info, (GTypeFlags) 0);
    }

    return type;
}

static void
scim_tomoe_prefs_win_class_init (ScimTomoePrefsWinClass *klass)
{
    GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

    parent_class = (GtkDialogClass *) g_type_class_peek_parent (klass);

    gobject_class->dispose = scim_tomoe_prefs_win_dispose;
}

static void
scim_tomoe_prefs_win_init (ScimTomoePrefsWin *prefs_win)
{
    gtk_window_set_title (GTK_WINDOW (prefs_win),
                          _("Preferences for handwriting pad"));
    gtk_window_set_icon_from_file (GTK_WINDOW (prefs_win),
                                   SCIM_ICONDIR "/scim-tomoe.png",
                                   NULL);
    gtk_window_set_default_size (GTK_WINDOW (prefs_win), 300, 300);

    gtk_dialog_add_buttons (GTK_DIALOG (prefs_win),
                            GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
                            NULL);

    GtkWidget *main_vbox = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (prefs_win)->vbox), main_vbox,
                        TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 8);
    gtk_widget_show (main_vbox);

    GtkWidget *notebook = gtk_notebook_new ();
    gtk_box_pack_start (GTK_BOX (main_vbox), notebook, TRUE, TRUE, 0);
    gtk_widget_show (notebook);

    GtkWidget *label = gtk_label_new (_("Common"));
    GtkWidget *vbox = gtk_vbox_new (FALSE, 0);
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox, label);
    gtk_widget_show (label);
    gtk_widget_show (vbox);

    // use auto find
    GtkWidget *check = gtk_check_button_new_with_mnemonic (_("Use auto _find"));
    gtk_container_set_border_width (GTK_CONTAINER (check), 4);
    gtk_box_pack_start (GTK_BOX (vbox), check, FALSE, FALSE, 0);
    g_object_set_data (G_OBJECT (check),
                       OBJECT_DATA_CONFIG_KEY,
                       (gpointer) SCIM_TOMOE_CONFIG_USE_AUTO_FIND);
    g_object_set_data (G_OBJECT (check),
                       OBJECT_DATA_CONFIG_VALUE,
                       GINT_TO_POINTER (SCIM_TOMOE_CONFIG_USE_AUTO_FIND_DEFAULT));
    g_signal_connect (G_OBJECT (check), "toggled",
                      G_CALLBACK (on_default_toggle_button_toggled),
                      prefs_win);
    gtk_widget_show (check);

    prefs_win->widget_list = g_list_append (prefs_win->widget_list, check);

    // table
    GtkWidget *table = gtk_table_new (4, 4, FALSE);
    gtk_box_pack_start (GTK_BOX (vbox), table, FALSE, FALSE, 0);
    gtk_widget_show (table);

    // auto find time
    label = gtk_label_new_with_mnemonic (_("_Interval time until start auto find:"));
    gtk_table_attach (GTK_TABLE (table), label, 0, 1, 1, 2,
                      (GtkAttachOptions) (GTK_FILL),
                      (GtkAttachOptions) (GTK_FILL),
                      4, 4);
    gtk_widget_show (label);

    GtkObject *adj = gtk_adjustment_new (0, 0.0, 99999.0, 50.0, 200.0, 200.0);
    GtkWidget *spin = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 0.0, 0);
    g_object_set_data (G_OBJECT (spin),
                       OBJECT_DATA_CONFIG_KEY,
                       (gpointer) SCIM_TOMOE_CONFIG_AUTO_FIND_TIME);
    g_object_set_data (G_OBJECT (spin),
                       OBJECT_DATA_CONFIG_VALUE,
                       GINT_TO_POINTER (SCIM_TOMOE_CONFIG_AUTO_FIND_TIME_DEFAULT));
    gtk_table_attach (GTK_TABLE (table), spin, 1, 2, 1, 2,
                      (GtkAttachOptions) (GTK_FILL),
                      (GtkAttachOptions) (GTK_FILL),
                      4, 4);
    g_signal_connect (G_OBJECT (spin), "value-changed",
                      G_CALLBACK (on_default_spin_button_changed),
                      prefs_win);
    gtk_widget_show (spin);

    gtk_label_set_mnemonic_widget (GTK_LABEL (label), spin);

    label = gtk_label_new ("[msec]");
    gtk_table_attach (GTK_TABLE (table), label, 2, 3, 1, 2,
                      (GtkAttachOptions) (GTK_FILL),
                      (GtkAttachOptions) (GTK_FILL),
                      4, 4);
    gtk_widget_show (label);

    g_signal_connect (G_OBJECT (check), "toggled",
                      G_CALLBACK (on_default_toggle_button_set_sensitive),
                      table);
    gtk_widget_set_sensitive (table, FALSE);

    prefs_win->widget_list = g_list_append (prefs_win->widget_list, spin);

    // clear the canvas
    check = gtk_check_button_new_with_mnemonic (
        _("_Clear the canvas when select a candidate"));
    gtk_container_set_border_width (GTK_CONTAINER (check), 4);
    gtk_box_pack_start (GTK_BOX (vbox), check, FALSE, FALSE, 0);
    g_object_set_data (G_OBJECT (check),
                       OBJECT_DATA_CONFIG_KEY,
                       (gpointer) SCIM_TOMOE_CONFIG_CLEAR_ON_SELECT);
    g_object_set_data (G_OBJECT (check),
                       OBJECT_DATA_CONFIG_VALUE,
                       GINT_TO_POINTER (SCIM_TOMOE_CONFIG_CLEAR_ON_SELECT_DEFAULT));
    g_signal_connect (G_OBJECT (check), "toggled",
                      G_CALLBACK (on_default_toggle_button_toggled),
                      prefs_win);
    gtk_widget_show (check);

    prefs_win->widget_list = g_list_append (prefs_win->widget_list, check);
}

static void
scim_tomoe_prefs_win_dispose (GObject *object)
{
    ScimTomoePrefsWin *prefs_win = SCIM_TOMOE_PREFS_WIN (prefs_win);

    prefs_win->config->flush ();
    prefs_win->config = NULL;

    if (G_OBJECT_CLASS(parent_class)->dispose)
        G_OBJECT_CLASS(parent_class)->dispose(object);
}

GtkWidget *
scim_tomoe_prefs_win_new (TomoeWindow *window, const ConfigPointer &config)
{
    GtkWidget *widget = GTK_WIDGET(g_object_new (SCIM_TOMOE_TYPE_PREFS_WIN,
                                                 NULL));
    ScimTomoePrefsWin *prefs_win = SCIM_TOMOE_PREFS_WIN (widget);

    prefs_win->config = config;
    prefs_win->parent = GTK_WIDGET (window);

    load_config (SCIM_TOMOE_PREFS_WIN(widget));

    return widget;
}

static void
load_config (ScimTomoePrefsWin *prefs_win)
{
    GList *node;

    if (prefs_win->config.null ())
        return;

    for (node = prefs_win->widget_list; node; node = g_list_next (node)) {
        GtkWidget *widget = GTK_WIDGET (node->data);

        if (GTK_IS_TOGGLE_BUTTON (widget)) {
            gpointer key_p, value_p;
            const char *key;
            bool value;

            key_p   = g_object_get_data (G_OBJECT (widget),
                                         OBJECT_DATA_CONFIG_KEY);
            value_p = g_object_get_data (G_OBJECT (widget),
                                         OBJECT_DATA_CONFIG_VALUE);

            key = (const char*) key_p;
            value = GPOINTER_TO_INT (value_p);

            value = prefs_win->config->read (String (key), value);
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widget), value);

        } else if (GTK_IS_SPIN_BUTTON (widget)) {
            gpointer key_p, value_p;
            const char *key;
            gint value;

            key_p   = g_object_get_data (G_OBJECT (widget),
                                         OBJECT_DATA_CONFIG_KEY);
            value_p = g_object_get_data (G_OBJECT (widget),
                                         OBJECT_DATA_CONFIG_VALUE);

            key = (const char*) key_p;
            value = GPOINTER_TO_INT (value_p);

            value = prefs_win->config->read (String (key), value);
            gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget), value);

        } else if (GTK_IS_EDITABLE (widget)) {
            // FIXME
        }
    }

    apply_config (prefs_win);
}

static void
apply_config (ScimTomoePrefsWin *prefs_win)
{
    TomoeWindow *parent = TOMOE_WINDOW (prefs_win->parent);
    TomoeCanvas *canvas = TOMOE_CANVAS (tomoe_window_get_canvas (parent));

    bool use_auto_find;
    gint time1, time2;

    time1 = tomoe_canvas_get_auto_find_time (canvas);

    use_auto_find = prefs_win->config->read (
        SCIM_TOMOE_CONFIG_USE_AUTO_FIND,
        SCIM_TOMOE_CONFIG_USE_AUTO_FIND_DEFAULT);

    time2 = prefs_win->config->read (
        SCIM_TOMOE_CONFIG_AUTO_FIND_TIME,
        SCIM_TOMOE_CONFIG_AUTO_FIND_TIME_DEFAULT);

    if (!use_auto_find)
        tomoe_canvas_set_auto_find_time (canvas, -1);
    else if (time1 != time2)
        tomoe_canvas_set_auto_find_time (canvas, time2);
}

static void
on_default_toggle_button_toggled (GtkToggleButton *togglebutton,
                                  gpointer user_data)
{
    ScimTomoePrefsWin *prefs_win = SCIM_TOMOE_PREFS_WIN (user_data);

    gboolean value = gtk_toggle_button_get_active (togglebutton);
    gpointer key_p   = g_object_get_data (G_OBJECT (togglebutton),
                                          OBJECT_DATA_CONFIG_KEY);
    const gchar *key = (const gchar *) key_p;
    if (key && *key)
        prefs_win->config->write (String (key), value);

    apply_config (prefs_win);
}

static void
on_default_toggle_button_set_sensitive (GtkToggleButton *togglebutton,
                                        gpointer user_data)
{
    GtkWidget *widget = GTK_WIDGET (user_data);
    gboolean active = gtk_toggle_button_get_active (togglebutton);
    gtk_widget_set_sensitive (widget, active);
}

static void
on_default_spin_button_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
    ScimTomoePrefsWin *prefs_win = SCIM_TOMOE_PREFS_WIN (user_data);

    gint value = (gint) gtk_spin_button_get_value (spinbutton);
    gpointer key_p   = g_object_get_data (G_OBJECT (spinbutton),
                                          OBJECT_DATA_CONFIG_KEY);
    const gchar *key = (const gchar *) key_p;
    if (key && *key)
        prefs_win->config->write (String (key), value);

    apply_config (prefs_win);
}
