/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.rfc2898;

import java.util.Arrays;
import net.y3n20u.rfc2898.PrfHmacSha1;
import net.y3n20u.rfc2898.PseudorandomFunction;
import net.y3n20u.util.ByteHelper;

public class Pbkdf2 {
    private static final String MESSAGE_DKLEN_TOO_LONG = "derived key too long";
    private final PseudorandomFunction _prf;

    public Pbkdf2() {
        this(new PrfHmacSha1());
    }

    public Pbkdf2(PseudorandomFunction pseudorandomFunction) {
        this._prf = pseudorandomFunction;
    }

    public byte[] deriveKey(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = this._prf.getLengthOfOutput();
        if (n2 > 29 * n3) {
            String string = String.format(MESSAGE_DKLEN_TOO_LONG, new Object[0]);
            throw new IllegalArgumentException(string);
        }
        int n4 = (int)Math.ceil((double)n2 / (double)n3);
        byte[][] byArrayArray = new byte[n4][];
        for (int i = 1; i <= n4; ++i) {
            byArrayArray[i - 1] = this._calculateF(byArray, byArray2, n, i);
        }
        return ByteHelper.concatByteArrays(n2, (byte[][])byArrayArray);
    }

    private byte[] _calculateF(byte[] byArray, byte[] byArray2, int n, int n2) {
        byte[] byArray3 = new byte[this._prf.getLengthOfOutput()];
        Arrays.fill(byArray3, (byte)0);
        byte[] byArray4 = ByteHelper.concatByteArrays(byArray2, this._getFourOctetEncoding(n2));
        for (int i = 0; i < n; ++i) {
            byArray4 = this._prf.getPseudorandomBytes(byArray, byArray4);
            byArray3 = ByteHelper.xorTwoByteArrays(byArray3, byArray4);
        }
        return byArray3;
    }

    private byte[] _getFourOctetEncoding(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)n;
        byArray[2] = (byte)(n >> 8);
        byArray[1] = (byte)(n >> 16);
        byArray[0] = (byte)(n >> 24);
        return byArray;
    }
}

