package net.y3n20u.aeszip;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;

import org.junit.Test;

public class AesZipDecrypterTest {

	@Test
	public void testDecryptAndUncompressStringFileString() {
		String password = "password";
		String[] sourceFiles = {"photo.jpg", "abc/abc.txt", "abc/aiueo.txt"};
		
		String srcBase = "./test/resource/";
		String encFileName = "./test/resource/abctest.zip";
		String decBase = "./test/resource/out2/";
		String suffix = "in2/";
		
		File source = new File(srcBase + suffix);
		File encDestination = new File(encFileName);
		File decDestination = new File(decBase);
		
		FileUtil.deleteRecursive(encDestination);
		FileUtil.deleteRecursive(decDestination);

		try {
			ExternalEncrypter enc = new ExternalEncrypterImpl();
			enc.setDestination(encFileName);
			for (String name: sourceFiles) {
				enc.add(name, new File(srcBase + suffix + name), password);
			}
			enc.archive();
			
			decDestination.mkdirs();
			AesZipDecrypter zipDec = new AesZipDecrypter(encDestination);
			for (String name : zipDec.getEntryNames()) {
				System.out.println(name);
				zipDec.decryptAndExtract(name, new File(decDestination, name), password);
			}
			assertTrue(FileUtil.compareFilesRecursive(source, decDestination));
		} catch (Exception e) {
			e.printStackTrace();
			fail(e.getMessage());
		}
	}

}
