package net.y3n20u.aeszip;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import net.y3n20u.rfc2898.Pbkdf2;
import net.y3n20u.util.ByteHelper;

public class AesCtrBlockCipherOutputStream extends FilterOutputStream {
	
	// TODO: I don't know the right setting for 'padding'
	/** name of algorithm used for encryption */
	public static final String CIPHER_MODE_AES_CTR = "AES/CTR/NoPadding";

	/** name of algorithm used for key construction */
	public static final String KEY_ALGORITHM = "AES";
	
	public static final byte[] INITIAL_IV = {0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0};
	private static final int BLOCK_SIZE = 16;
	private static final int NONCE_SIZE = 8;

	private static final byte BYTE_HEX_FF = (byte)0xff;
	
	private Cipher _cipher;
	private Key _encryptKey;
	private final byte[] _iv = new byte[16];
	private final byte[] _restBytes = new byte[16];
	private int _restBytesLength;
	
	public AesCtrBlockCipherOutputStream(OutputStream out) {
		super(out);
		try {
			_cipher = Cipher.getInstance(CIPHER_MODE_AES_CTR);
		} catch (NoSuchAlgorithmException nsae) {
			// FIXME Auto-generated catch block
			throw new RuntimeException(nsae);
		} catch (NoSuchPaddingException nspe) {
			// FIXME Auto-generated catch block
			throw new RuntimeException(nspe);
		}
	}
	public void init(byte[] keyBytes) {
		System.arraycopy(INITIAL_IV, 0, _iv, 0, BLOCK_SIZE);
		_encryptKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
		_restBytesLength = 0;
	}
	
	private void _initIvAndCipher() {
		IvParameterSpec ivParameter = new IvParameterSpec(_iv);
		try {
			_cipher.init(Cipher.ENCRYPT_MODE, _encryptKey, ivParameter);
		} catch (InvalidKeyException ike) {
			// FIXME Auto-generated catch block
			throw new RuntimeException(ike);
		} catch (InvalidAlgorithmParameterException iape) {
			// FIXME: Auto-generated catch block
			throw new RuntimeException(iape);
		}
	}
	
	@Override
	public void write(byte[] b, int off, int len) throws IOException {
		if (_restBytesLength > 0) {
			int length = BLOCK_SIZE - _restBytesLength;
			if (len < length) {
				System.arraycopy(b, off, _restBytes, _restBytesLength, len);
				_restBytesLength += len;
				return;
			}
			byte[] buffer = new byte[BLOCK_SIZE];
			System.arraycopy(_restBytes, 0, buffer, 0, _restBytesLength);
			System.arraycopy(b, off, buffer, _restBytesLength, length);
			_encryptAndWriteBlock(buffer, 0, BLOCK_SIZE);
			off += length;
			len -= length;
			_restBytesLength = 0;
		}
		int i = off;
		for ( ; i + BLOCK_SIZE <= off + len; i += BLOCK_SIZE) {
			_encryptAndWriteBlock(b, i, BLOCK_SIZE);
		}
		int m = off + len - i;
		if (m > 0) {
			_restBytesLength = m;
			System.arraycopy(b, i, _restBytes, 0, m);
		}
	}
	
	private void _encryptAndWriteBlock(byte[] b, int off, int len) throws IOException {
		try {
			this._incrementIv();
			this._initIvAndCipher();
			byte[] buffer = _cipher.doFinal(b, off, len);
			this.out.write(buffer, 0, buffer.length);
		} catch (IllegalBlockSizeException e) {
			// FIXME Auto-generated catch block
			e.printStackTrace();
		} catch (BadPaddingException e) {
			// FIXME Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private void _incrementIv() {
		for (int i = 0; i < NONCE_SIZE; i++) {
			if (_iv[i] != BYTE_HEX_FF) {
				_iv[i]++;
				return;
			}
			_iv[i] = 0;
		}
		// FIXME: nonce overflow check.
		throw new IllegalStateException();
	}
	
	@Override
	public void flush() throws IOException {
		if (_restBytesLength > 0) {
			_encryptAndWriteBlock(_restBytes, 0, _restBytesLength);
			_restBytesLength = 0;
		}
		this.out.flush();
	}

}
