/*
 * Decompiled with CFR 0.152.
 */
package net.y3n20u.aeszip;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import net.y3n20u.aeszip.AesZipEncrypter;

public class AesZipRecursiveEncrypter
extends AesZipEncrypter {
    private FileFilter fileFilter;
    private URI baseURI;
    private String password;
    private File source;

    public AesZipRecursiveEncrypter(File file, String string) {
        this(file, string, new File(file.getParent(), file.getName() + ".zip"));
    }

    public AesZipRecursiveEncrypter(File file, String string, OutputStream outputStream) {
        super(outputStream);
        this.setSourceAndPassword(file, string);
    }

    public AesZipRecursiveEncrypter(File file, String string, File file2) {
        super(file2);
        this.setSourceAndPassword(file, string);
    }

    private void setSourceAndPassword(File file, String string) {
        if (file == null || string == null) {
            throw new IllegalArgumentException(new NullPointerException());
        }
        this.source = file;
        this.password = string;
        this.baseURI = file.getParentFile().toURI();
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    private boolean checkFileFilter(File file) {
        if (this.fileFilter == null) {
            return true;
        }
        return this.fileFilter.accept(file);
    }

    @Override
    public void archive() throws IOException {
        this.archiveImplRecursive(this.source);
        super.archive();
    }

    private void archiveImplRecursive(File file) {
        if (!this.checkFileFilter(file)) {
            return;
        }
        String string = this.baseURI.relativize(file.toURI()).getPath();
        string = string + (file.isDirectory() && !string.endsWith("/") ? "/" : "");
        this.add(string, file, this.password);
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                this.archiveImplRecursive(file2);
            }
        }
    }
}

