package net.y3n20u.aeszip;

/**
 * integer mode value indicating AES encryption strength:
 * <ul>
 * <li>1 (128-bit encryption key, 8-byte salt)
 * <li>2 (192-bit encryption key, 12-byte salt)
 * <li>3 (256-bit encryption key, 16-byte salt) default.
 * </ul>
 * <p>
 */
public enum EncryptionStrengthMode {
	ONE(1, 16, 8),
	TWO(2, 24, 12),
	THREE(3, 32, 16);
	
	private final byte modeValue;
	private final int keyLength;
	private final int saltLength;
	
	/**
	 * @param modeValue strength mode value used in the AES extra field
	 * @param keyLength length of the encryption key (bytes)
	 * @param saltLength length of the salt value (bytes)
	 */
	private EncryptionStrengthMode(int modeValue, int keyLength, int saltLength) {
		this.modeValue = (byte)modeValue;
		this.keyLength = keyLength;
		this.saltLength = saltLength;
	}

	public byte getModeValue() {
		return modeValue;
	}

	public int getKeyLength() {
		return keyLength;
	}

	public int getSaltLength() {
		return saltLength;
	}
}