//
//  GrowlNotifier.h
//  Afficheur
//
//  Created by kichi on 08/04/07.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "Growl/Growl.h"


@interface GrowlNotifier : NSObject <GrowlApplicationBridgeDelegate> {
	id						_delegate;
	NSMutableDictionary*	_dict;
}

- (GrowlNotifier *)initWithDelegate:(id)delegate;
- (void)startWithApplicationName:(NSString *)applicationName
				   notifications:(NSArray *)notifications
			dafaultNotifications:(NSArray *)defaultNotifications
							icon:(NSImage *)icon;
- (void)notifyWithTitle:(NSString *)title
			description:(NSString *)description
	   notificationName:(NSString *)notificationName
			   iconData:(NSData *)iconData
			   priority:(signed int)priority
			   isSticky:(BOOL)isSticky
		   clickContext:(id)clickContext;

@end
