//
//  GrowlNotifier.m
//  Afficheur
//
//  Created by kichi on 08/04/07.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "GrowlNotifier.h"
#import "HotKeyedApplication.h"


@implementation GrowlNotifier

- (GrowlNotifier *)initWithDelegate:(id)delegate
{
	NSLog(@"%@#init", [self class]);
	_dict = nil;
	_delegate = nil;
	self = [super init];
	if (self)
	{
		NSLog(@"%@#init:", [self class]);
		_dict = [[[NSMutableDictionary alloc] initWithObjectsAndKeys:
				  //[[NSProcessInfo processInfo] processIdentifier], GROWL_APP_PID,
				  nil] retain];
		_delegate = delegate;
	}
	return self;
}

- (void)dealloc
{
	[_dict release];
	[super dealloc];
}

- (void)startWithApplicationName:(NSString *)applicationName
				   notifications:(NSArray *)notifications
			dafaultNotifications:(NSArray *)defaultNotifications
							icon:(NSImage *)icon
{
	NSLog(@"%@#startWithApplicationName: %@", [self class], applicationName);
	[_dict setValue:applicationName forKey:GROWL_APP_NAME];
	[_dict setValue:notifications forKey:GROWL_NOTIFICATIONS_ALL];
	if (defaultNotifications)
	{
		[_dict setValue:defaultNotifications forKey:GROWL_NOTIFICATIONS_DEFAULT];
	}
	else
	{
		[_dict setValue:notifications forKey:GROWL_NOTIFICATIONS_DEFAULT];
	}
	NSImage* img = icon;
	if (!img)
	{
		img = [[NSApplication sharedApplication] applicationIconImage];
	}
	[_dict setValue:[img TIFFRepresentation] forKey:GROWL_APP_ICON];
    if ([GrowlApplicationBridge isGrowlInstalled])
	{
		if (![GrowlApplicationBridge isGrowlRunning])
		{
			NSLog(@"%@#start: launchGrowlHelperApp", [self class]);
			[[NSWorkspace sharedWorkspace] launchApplication:@"GrowlHelperApp"];
		}
		else
		{
			NSLog(@"%@#start: isGrowlRunning", [self class]);
		}
	}
	else
	{
		NSLog(@"%@#start: ! isGrowlInstalled", [self class]);
	}
	[GrowlApplicationBridge setGrowlDelegate:self];
}

- (void)notifyWithTitle:(NSString *)title
			description:(NSString *)description
	   notificationName:(NSString *)notificationName
			   iconData:(NSData *)iconData
			   priority:(signed int)priority
			   isSticky:(BOOL)isSticky
		   clickContext:(id)clickContext
{
	[GrowlApplicationBridge notifyWithTitle:title
								description:description
						   notificationName:notificationName
								   iconData:iconData
								   priority:priority
								   isSticky:isSticky
							   clickContext:clickContext];
}

//	Growl delegate

- (NSDictionary *)registrationDictionaryForGrowl
{
	NSLog(@"%@#registrationDictionaryForGrowl:", [self class]);
	return _dict;
}

- (NSString *)applicationNameForGrowl
{
	NSLog(@"%@#applicationNameForGrowl:", [self class]);
	return [_dict valueForKey:GROWL_APP_NAME];
}

- (NSData *)applicationIconDataForGrowl
{
	NSLog(@"%@#applicationIconDataForGrowl:", [self class]);
	return [_dict valueForKey:GROWL_APP_ICON];
}

- (void)growlIsReady
{
	NSLog(@"%@#growlIsReady:", [self class]);
	if (_delegate && [_delegate respondsToSelector:@selector(growlIsReady)])
	{
		NSLog(@"%@#growlIsReady: perform", [self class]);
		[_delegate performSelector:@selector(growlIsReady)];
	}
}

- (void)growlNotificationWasClicked:(id)clickContext
{
	NSLog(@"%@#growlNotificationWasClicked: %@", [self class], clickContext);
	if (_delegate && [_delegate respondsToSelector:@selector(growlNotificationWasClicked:)])
	{
		NSLog(@"%@#growlNotificationWasClicked: perform", [self class]);
		[_delegate performSelector:@selector(growlNotificationWasClicked:) withObject:clickContext];
	}
}

- (void)growlNotificationTimedOut:(id)clickContext
{
	NSLog(@"%@#growlNotificationTimedOut: %@", [self class], clickContext);
	if (_delegate && [_delegate respondsToSelector:@selector(growlNotificationTimedOut:)])
	{
		NSLog(@"%@#growlNotificationTimedOut: perform", [self class]);
		[_delegate performSelector:@selector(growlNotificationTimedOut:) withObject:clickContext];
	}
}

@end
