//
//  HTTP.m
//  Afficheur
//
//  Created by kichi on 08/04/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "HTTP.h"
#import <openssl/bio.h>
#import <openssl/buffer.h>
#import <openssl/evp.h>


@implementation HTTP

+ (NSString *)base64String:(NSString *)string
{
	const char *cstr = [string cStringUsingEncoding:NSASCIIStringEncoding];
	BIO *b64 = BIO_new(BIO_f_base64());
	BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
	BIO *bio = BIO_new(BIO_s_mem());
	bio = BIO_push(b64, bio);
	BIO_write(bio, cstr, strlen(cstr));
	BIO_flush(bio);
	BUF_MEM *ptr;
	BIO_get_mem_ptr(b64, &ptr);
	char *buf = malloc(ptr->length + 1);
	memcpy(buf, ptr->data, ptr->length);
	buf[ptr->length] = '\0';
	BIO_free_all(bio);
	NSString *res = [NSString stringWithCString:(char*)buf encoding:NSASCIIStringEncoding];
	free(buf);
	return res;
}

+ (NSString *)urlEncode:(NSString *)string
{
	//NSLog(@"%@#urlEncode: '%@'", [self class], string);
	NSString *encode = (NSString *)CFURLCreateStringByAddingPercentEscapes(NULL,
																		   (CFStringRef)string,
																		   NULL,
																		   NULL,
																		   kCFStringEncodingUTF8);
	//NSLog(@"%@#urlEncode: '%@'", [self class], encode);
	return encode;
}

+ (NSString *)urlEncode:(NSString *)string
			  unescaped:(NSString *)unescaped
				escaped:(NSString *)escaped
{
	//NSLog(@"%@#urlEncode: '%@'", [self class], string);
	NSString *encode = (NSString *)CFURLCreateStringByAddingPercentEscapes(NULL,
																		   (CFStringRef)string,
																		   (CFStringRef)unescaped,
																		   (CFStringRef)escaped,
																		   kCFStringEncodingUTF8);
	//NSLog(@"%@#urlEncode: '%@'", [self class], encode);
	return encode;
}

- (NSArray *)post:(NSString *)path
	header:(NSDictionary *)header
	  body:(NSString *)body
{
	NSURL *url = [NSURL URLWithString:path];
	//NSLog(@"%@#post:url = %@", [self class], url);
	NSMutableURLRequest *req = [[NSMutableURLRequest alloc] initWithURL:url];
	NSEnumerator *enumerator = [header keyEnumerator];
	id key;
	while (key = [enumerator nextObject])
	{
		[req addValue:[header valueForKey:key] forHTTPHeaderField:key];
		//NSLog(@"%@#post: val = %@ key = %@", [self class], [header valueForKey:key], key);
	}
	[req setHTTPMethod:@"POST"];
	[req setHTTPBody:[body dataUsingEncoding:NSUTF8StringEncoding]];
	//NSLog(@"%@#post: body = %@", [self class], body);
	//NSLog(@"%@#post: req = %@", [self class], req);
	NSURLResponse *response;
	NSError *error;
	NSData *data = [NSURLConnection sendSynchronousRequest:req
										   returningResponse:&response
													   error:&error];
	if (!error)
	{
		error = (NSError *)[NSNull null];
	}
	if (!response)
	{
		response = (NSURLResponse *)[NSNull null];
	}
	if (!data)
	{
		data = (NSData *)[NSNull null];
	}
	NSLog(@"%@#post: result = %@", [self class], [[[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding] autorelease]);
	NSLog(@"%@#post: res = %@", [self class], response);
	NSLog(@"%@#post: error = %@", [self class], error);
	return [NSArray arrayWithObjects:error, response, data, nil];
}

@end
