//
//  JaikuAPI.m
//  Afficheur
//
//  Created by kichi on 08/04/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "JaikuAPI.h"
#import <JSON/JSON.h>
#import <OgreKit/OgreKit.h>

NSString *JaikuUser	= @"JaikuUser";
NSString *JaikuPass	= @"JaikuPass";
NSString *JaikuHost	= @"JaikuHost";
NSString *JaikuURL	= @"JaikuURL";

@implementation JaikuAPI

- (JaikuAPI *)init
{
	self = [super init];
	if (self)
	{
		_keys = [NSDictionary dictionaryWithObjectsAndKeys:
				 @"", JaikuUser,
				 @"", JaikuPass,
				 @"", JaikuHost,
				 @"", JaikuURL,
				 nil];
		_dic = [[[NSMutableDictionary alloc] initWithObjectsAndKeys:
				 @"", JaikuUser,
				 @"", JaikuPass,
				 @"api.jaiku.com", JaikuHost,
				 @"http://api.jaiku.com", JaikuURL,
				 nil] retain];
		//NSLog(@"%@#init: %@", [self class], _dic);
	}
	return self;
}

- (void)dealloc
{
	[_dic release];
	[super dealloc];
}

- (JaikuAPI *)initWithObjectsAndKeys:(id)firstObject, ...
{
	[self init];
	id obj = firstObject;
	va_list	ap;
	va_start(ap, firstObject);
	while (obj)
	{
		id key = va_arg(ap, id);
		if (key == nil)
		{
			break;
		}
		id val = [_keys valueForKey:key];
		if (val == nil)
		{
			NSLog(@"%@#initWithObjectsAndKeys: NoKey: %@", [self class], key);
		}
		else
		{
			[_dic setValue:obj forKey:key];
		}
		obj = va_arg(ap, id);
	}
	va_end(ap);
	//NSLog(@"%@#initWithObjectsAndKeys: %@", [self class], db);
	return self;
}

- (id)postWithAuth:(NSString *)path
			header:(NSMutableDictionary *)aHeader
			  body:(NSString *)aBody
{
	//NSLog(@"%@#post:surl = %@", [self class], surl);
	[aHeader setValue:[_dic valueForKey:JaikuHost] forKey:@"Host"];
	//NSLog(@"%@#postWithAuth: body = '%@'", [self class], aBody);
	return [self post:[NSString stringWithFormat:@"%@/%@", [_dic valueForKey:JaikuURL], path]
			   header:aHeader
				 body:[NSString stringWithFormat:@"user=%@&personal_key=%@&%@",
					   [_dic valueForKey:JaikuUser],
					   [_dic valueForKey:JaikuPass],
					   aBody]];
}

- (NSString *)determineError:(NSError *)error
					response:(NSURLResponse *)response
					  result:(id)result
{
	NSLog(@"%@#determineResponse: error = %@", [self class], error);
	NSLog(@"%@#determineResponse: response = %@", [self class], response);
	NSLog(@"%@#determineResponse: result = %@", [self class], result);
	NSString *description = nil;
	if ([result isKindOfClass:[NSDictionary class]])
	{
		NSString *status = [result valueForKey:@"status"];
		NSString *message = [result valueForKey:@"message"];
		NSLog(@"%@#determineResponse: status = %@", [self class], status);
		NSLog(@"%@#determineResponse: message = %@", [self class], message);
		if (message)
		{
			description = [NSString stringWithFormat:@"Failure\n(%@)", message];
		}
	}
	NSLog(@"%@#determineResponse: description = %@", [self class], description);
	return description;
}

- (NSArray *)update:(NSString *)status
{
	NSArray *res = [self postWithAuth:@"update.json"
							   header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
										@"application/x-www-form-urlencoded",
										@"Content-Type",
										nil]
									   autorelease]
								 body:[NSString stringWithFormat:
									   @"method=presence.send&message=%@",
									   [HTTP urlEncode:status
											 unescaped:nil
											   escaped:@"+"]]];
	NSError *error = (NSError *)[NSNull null];
	NSURLResponse *response = (NSURLResponse *)[NSNull null];
	id result = [NSNull null];
	if ([res count] > ResultError)
	{
		error = [res objectAtIndex:ResultError];
	}
	if ([res count] > ResultResponse)
	{
		response = [res objectAtIndex:ResultResponse];
	}
	if ([res count] > ResultData)
	{
		result = [[NSString alloc] initWithData:[res objectAtIndex:ResultData]
									   encoding:NSUTF8StringEncoding];
	}
	if ([error class] == [NSNull class])
	{
		result = [result JSONValue];
	}
	NSString *description = [self determineError:(NSError *)error
										response:(NSURLResponse *)response
										  result:(id)result];
	if (!description)
	{
		description = (NSString *)[NSNull null];
	}
	return [NSArray arrayWithObjects:
			error,
			response,
			result,
			description,
			nil];
}
@end
