//
//  TinyURL.m
//  Afficheur
//
//  Created by kichi on 08/04/10.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "TinyURL.h"
#import "HTTP.h"


@implementation TinyURL

+ (NSString *)create:(NSString *)url
{
	NSString *path = [NSString stringWithFormat:@"http://tinyurl.com/api-create.php?url=%@", [HTTP urlEncode:url]];
	NSLog(@"%@#create: path = %@", [self class], path);
	NSMutableURLRequest *req = [[NSMutableURLRequest alloc] initWithURL:[NSURL URLWithString:path]];
	[req setHTTPMethod:@"GET"];
	[req setHTTPBody:[@"" dataUsingEncoding:NSUTF8StringEncoding]];
	NSURLResponse *response;
	NSError *error;
	NSData *data = [NSURLConnection sendSynchronousRequest:req
										 returningResponse:&response
													 error:&error];
	if (error || !data)
	{
		return nil;
	}
	NSLog(@"%@#create: result = %@", [self class],
		  [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding]);
	[req release];
	return [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
}

@end
