//
//  TumblrAPI.m
//  Afficheur
//
//  Created by kichi on 08/04/07.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "TumblrAPI.h"
#import <JSON/JSON.h>
#import <OgreKit/OgreKit.h>

NSString *TumblrUser		= @"TumblrUser";
NSString *TumblrPass		= @"TumblrPass";
NSString *TumblrHost		= @"TumblrHost";
NSString *TumblrURL			= @"TumblrURL";
NSString *TumblrGenerator	= @"TumblrGenerator";

@implementation TumblrAPI

- (TumblrAPI *)init
{
	self = [super init];
	if (self)
	{
		_keys = [NSDictionary dictionaryWithObjectsAndKeys:
				 @"", TumblrUser,
				 @"", TumblrPass,
				 @"", TumblrHost,
				 @"", TumblrURL,
				 @"", TumblrGenerator,
				 nil];
		_dic = [[[NSMutableDictionary alloc] initWithObjectsAndKeys:
				 @"", TumblrUser,
				 @"", TumblrPass,
				 @"www.Tumblr.com", TumblrHost,
				 @"http://www.Tumblr.com/api", TumblrURL,
				 nil] retain];
		//NSLog(@"%@#init: %@", [self class], _dic);
	}
	return self;
}

- (void)dealloc
{
	[_dic release];
	[super dealloc];
}

- (TumblrAPI *)initWithObjectsAndKeys:(id)firstObject, ...
{
	[self init];
	id obj = firstObject;
	va_list	ap;
	va_start(ap, firstObject);
	while (obj)
	{
		id key = va_arg(ap, id);
		if (key == nil)
		{
			break;
		}
		id val = [_keys valueForKey:key];
		if (val == nil)
		{
			NSLog(@"%@#initWithObjectsAndKeys: NoKey: %@", [self class], key);
		}
		else
		{
			NSLog(@"%@#initWithObjectsAndKeys: %@ = %@", [self class], key, obj);
			[_dic setValue:obj forKey:key];
		}
		obj = va_arg(ap, id);
	}
	va_end(ap);
	//NSLog(@"%@#initWithObjectsAndKeys: %@", [self class], db);
	return self;
}


- (id)postWithAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body
{
	NSString *generator = @"";
	if ([_dic valueForKey:TumblrGenerator])
	{
		generator = [NSString stringWithFormat:@"&generator=%@", [_dic valueForKey:TumblrGenerator]];
	}
	NSString *auth = [HTTP base64String:
					  [NSString stringWithFormat:@"%@:%@",
					   [_dic valueForKey:TumblrUser],
					   [_dic valueForKey:TumblrPass]]];
	[header setValue:[_dic valueForKey:TumblrHost] forKey:@"Host"];
	[header setValue:[NSString stringWithFormat:@"Basic %@", auth] forKey:@"Authorization"];
	return [self post:[NSString stringWithFormat:@"%@/%@", [_dic valueForKey:TumblrURL], path]
			   header:header
				 body:[NSString stringWithFormat:@"email=%@&password=%@&%@%@",
					   [HTTP urlEncode:[_dic valueForKey:TumblrUser]
							 unescaped:nil
							   escaped:@"+"],
						[HTTP urlEncode:[_dic valueForKey:TumblrPass]
							  unescaped:nil
								escaped:@"+"],
					   body,
					   generator]];
}

- (NSString *)determineError:(NSError *)error
					response:(NSURLResponse *)response
					  result:(id)result
{
	NSLog(@"%@#determineResponse: error = %@", [self class], error);
	NSLog(@"%@#determineResponse: response = %@", [self class], response);
	NSLog(@"%@#determineResponse: result = %@", [self class], result);
	NSString *description = nil;
	if (![error isKindOfClass:[NSNull class]])
	{
		description = @"Failure";
		if ([result isKindOfClass:[NSString class]])
		{
			if ([result rangeOfRegularExpressionString:@"^<!DOCTYPE HTML"
											   options:OgreIgnoreCaseOption].length ||
				[result rangeOfRegularExpressionString:@"^<HTML"
											   options:OgreIgnoreCaseOption].length)
			{
				// 正規表現オブジェクトの生成
				OGRegularExpression *regex = [OGRegularExpression
											  regularExpressionWithString:@"<TITLE>(.*)</TITLE>$"
											  options:OgreIgnoreCaseOption | OgreMultilineOption];
				// マッチ結果の列挙子の生成
				OGRegularExpressionMatch *match = [regex matchInString:result];
				NSString *title = [match substringAtIndex:1];
				if (title)
				{
					result = title;
				}
			}
			description = [NSString stringWithFormat:@"Failure\n(%@)", result];
		}
	}
	else if (![result rangeOfRegularExpressionString:@"^[0-9]+$" options:OgreIgnoreCaseOption].length)
	{
		description = [NSString stringWithFormat:@"Failure\n(%@)", result];
	}
	NSLog(@"%@#determineResponse: description = %@", [self class], description);
	return description;
}

- (id)createLink:(NSString *)link
		   title:(NSString *)title
{
	NSString *name = @"";
	if (title && ![title isEqual:@""])
	{
			name = [NSString stringWithFormat:@"&name=%@", [HTTP urlEncode:title
																 unescaped:nil
																   escaped:@"+"]];
	}
	id res = [self postWithAuth:@"write"
						 header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
								  @"application/x-www-form-urlencoded",
								  @"Content-Type",
								  nil]
								 autorelease]
						   body:[NSString stringWithFormat:@"type=link&url=%@%@",
								 [HTTP urlEncode:link
									   unescaped:nil
										 escaped:@"+"],
								 name]];
	NSError *error = (NSError *)[NSNull null];
	NSURLResponse *response = (NSURLResponse *)[NSNull null];
	id result = [NSNull null];
	if ([res count] > ResultError)
	{
		error = [res objectAtIndex:ResultError];
	}
	if ([res count] > ResultResponse)
	{
		response = [res objectAtIndex:ResultResponse];
	}
	if ([res count] > ResultData)
	{
		result = [[NSString alloc] initWithData:[res objectAtIndex:ResultData]
									   encoding:NSUTF8StringEncoding];
	}
	NSString *description = [self determineError:(NSError *)error
										response:(NSURLResponse *)response
										  result:(id)result];
	if (!description)
	{
		description = (NSString *)[NSNull null];
	}
	return [NSArray arrayWithObjects:
			error,
			response,
			result,
			description,
			nil];
}
@end
