//
//  KeyEquivView.h
//  Afficheur
//
//  Created by kichi on 08/04/10.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Carbon/Carbon.h>
#import <Cocoa/Cocoa.h>

@class KeyEquivField;


@interface KeyEquivView : NSTextView {
    KeyboardLayoutRef	_keyboardLayout;
    UCKeyboardLayout*	_uchrData;
    void*				_KCHRData;
    SInt32				_keyLayoutKind;
    UInt32				_keyTranslateState;
    UInt32				_deadKeyState;
	NSDictionary*		_functionKeys;
	NSArray*			_padKeys;
	KeyEquivField*		_textField;
	UInt32				_keyCode;

	BOOL				_enableKeyDown;

	NSImage*			_cancelButton;
	NSImage*			_cancelPush;
}

+ (UInt16)keyCodeForKeyCode:(UInt32)keyCode;
+ (UInt32)modifierKeyForKeyCode:(UInt32)keyCode;

- (void)setTextField:(KeyEquivField *)textField;

- (UInt32)keyCode;
- (BOOL)isValidKeyCode;
- (void)setKeyCode:(UInt32)keyCode;

- (void)setEnableKeyDown:(BOOL)enable;
- (BOOL)isEnableKeyDown;

- (void)setCancelButton;
- (void)setPushedCancelButton;
- (BOOL)isCancelButton;
- (BOOL)isPushedCancelButton;

@end
