//
//  ServiceIdentica.m
//  Afficheur
//
//  Created by kichi on 08/10/06.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "ServiceIdentica.h"
#import "AfficheurController.h"
#import "AfficheurPreferences.h"
#import "AfficheurTimeline.h"
#import "AfficheurGrowl.h"
#import "NSStringOgreKit.h"
#import <OgreKit/OgreKit.h>
#import "ServiceXMPP.h"
#import "ServiceXMPPClient.h"
#import "XMPPStream.h"
#import "NSXMLElementAdditions.h"
#import "i18n.h"


@implementation ServiceIdentica

- (id)init
{
	self = (id)[super init];
	if (self)
	{
	}
	return self;
}

- (void)dealloc
{
	[super dealloc];
}

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences
{
	self = [super init:service
		WithController:controller
		   preferences:preferences];
	if (self)
	{
	}
	return self;
}

- (void)setupXMPP:(ServiceXMPP *)xmpp
{
	[xmpp addService:Identica withObject:self];
	if ([_preferences accountIdenticaUseXMPP])
	{
		[xmpp addXMPP:Identica
			  withJid:[_preferences accountIdenticaJidXMPP]
				 pass:[_preferences accountIdenticaPassXMPP]
			   server:[_preferences accountIdenticaServerXMPP]
				 port:[_preferences accountIdenticaPortXMPP]
			  offline:[_preferences accountIdenticaOfflineXMPP]];
	}
	else
	{
		[xmpp removeXMPP:Identica];
	}
}

- (BOOL)checkRetrieveTimeline:(NSDate *)now
{
	return [self checkRetrieve:now
					  withDate:_dateTimeline
					  interval:[_preferences accountIdenticaIntervalTimeline]];
}

- (BOOL)checkRetrieveReplies:(NSDate *)now
{
	return [self checkRetrieve:now
					  withDate:_dateReplies
					  interval:[_preferences accountIdenticaIntervalReplies]];
}

- (NSString *)stringChannel:(NSString *)text
{
	if ([text rangeOfRegularExpressionString:@"\\![a-zA-Z][\\!-~]+"].length > 0)
	{
		return [text replaceWithExpression:@"^.*(\\![a-zA-Z][\\!-~]+).*$" replace:@"\\1"];
	}
	return nil;
}

- (BOOL)checkRetrieveDM:(NSDate *)now
{
	return [self checkRetrieve:now
					  withDate:_dateDM
					  interval:[_preferences accountIdenticaIntervalDM]];
}

- (void)post:(NSString *)status
   withReply:(NSString *)reply
{
	@synchronized(self)
	{
		@try
		{
			if (![reply isEqualToString:@""])
			{
				reply = [NSString stringWithFormat:@"&in_reply_to_status_id=%@", reply];
			}
			NSString *user = [_preferences accountIdenticaUser];
			NSString *pass = [_preferences accountIdenticaPass];
			NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:
								 @"identi.ca", TwitterHost,
								 @"http://identi.ca/api/statuses", TwitterURL,
								 user, TwitterUser,
								 pass, TwitterPass,
								 Afficheur, TwitterSource,
								 nil];
			if ([_preferences generalConvertEmoji])
			{
				status = [self stringFromEmoji:status];
			}
			[NSThread detachNewThreadSelector:@selector(performPost:)
									 toTarget:self
								   withObject:[[NSArray alloc] initWithObjects:status, dic, reply, nil]];
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@(%@) post] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
		}
	}
}

- (BOOL)isChannel:(NSDictionary *)object
{
	return [[object valueForKey:KeyNotify] isEqualToString:GrowlAfficheurIdenticaGroupNotify];
}

- (NSDictionary *)parse:(NSDictionary *)obj
			   withUser:(NSString *)user_id
				   kind:(int)kind
				  first:(BOOL)first
{
	if (![obj isKindOfClass:[NSDictionary class]])
	{
		return nil;
	}
	int loop = (kind >> 8) & 0xfffff;
	kind &= 0xff;
	//LOG(@"[%@(%@) parse:%d]\n%@", [self className], _service, kind, obj);
	NSDictionary *item = nil;
	@try
	{
		NSString *item_id = [NSString stringWithFormat:@"%@", [obj valueForKey:@"id"]];
		NSDictionary *user = [obj valueForKey:@"user"];
		if (!user)
		{
			user = [obj valueForKey:@"sender"];
		}
		NSString *screen_name = [user valueForKey:@"screen_name"];
		NSString *user_name = [user valueForKey:@"name"];
		if (!user_name)
		{
			user_name = @"";
		}
		else if ([user_name isKindOfClass:[NSNull class]])
		{
			user_name = @"";
		}
		user_name = [self convertText:user_name];
		NSString *name = @"";
		if ((![user_name isEqualToString:@""]) &&(![user_name isEqualToString:screen_name]))
		{
			name = [NSString stringWithFormat:@" / %@", user_name];
		}
		NSString *user_profile = [user valueForKey:@"profile_image_url"];
		NSString *date = [obj valueForKey:@"created_at"];
		NSString *channel = @"";
		NSString *text = [obj valueForKey:@"text"];
		NSString *comment = @"";
		NSString *notify = _notify;
		NSString *kindStr = KindTimeline;
		NSString *inReplyUser = nil;
		if (!text || [text isKindOfClass:[NSNull class]])
		{
			text = @"";
		}
		if (![screen_name isEqualToString:user_id] && [self hasKeyword:text])
		{
			notify = GrowlAfficheurKeywordsNotify;
			first = NO;
		}
		if ((kind == kindTimeline) || (kind == kindChannel))
		{
			channel = [self stringChannel:text];
			if (channel)
			{
				notify = GrowlAfficheurIdenticaGroupNotify;
				channel = [NSString stringWithFormat:@" %@", channel];
			}
			else
			{
				channel = @"";
			}
		}
		if (kind == kindReply)
		{
			notify = _notifyReply;
			kindStr = KindReply;
		}
		else if (kind == kindDM)
		{
			notify = _notifyDM;
			kindStr = KindDM;
		}
		id in_reply = [obj valueForKey:@"in_reply_to_status_id"];
		if (!in_reply || [in_reply isKindOfClass:[NSNull class]])
		{
			if ((kind == kindTimeline) || (kind == kindChannel))
			{
				if (([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@$", user_id]] > 0) ||
					([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@[^!-~]", user_id]] > 0))
				{
					notify = _notifyReply;
					first = NO;
				}
			}
		}
		else
		{
			NSDictionary *reply = [self fetchALL:[NSString stringWithFormat:@"%@", in_reply]
								  withService:_service];
			if (!reply)
			{
				NSString *user = [_preferences accountIdenticaUser];
				NSString *pass = [_preferences accountIdenticaPass];
				TwitterAPI *api = [[TwitterAPI alloc] initWithDictionary:
								   [NSDictionary dictionaryWithObjectsAndKeys:
									@"identi.ca", TwitterHost,
									@"http://identi.ca/api/statuses", TwitterURL,
									user, TwitterUser,
									pass, TwitterPass,
									nil]];
				if (api)
				{
					id notice = [api show:in_reply];
					LOG(@"[%@(%@) parse:%d] reply: %d / %@", [self className], _service, kind, loop, in_reply);
					if (notice && [notice isKindOfClass:[NSDictionary class]])
					{
						id reply_item = nil;
						if (loop < 50)
						{
							reply_item = [self parse:notice
											withUser:user_id
												kind:kind | (((loop + 1) << 8) & 0xfffff00)
											   first:first];
						}
						if (reply_item)
						{
							if ([self addTimeline:reply_item])
							{
								[_controller  queueingParsePhotoURL:reply_item];
							}
							reply = reply_item;
						}
						else
						{
							reply = [NSDictionary dictionaryWithObjectsAndKeys:
									 [[notice valueForKey:@"user"] valueForKey:@"screen_name"], KeyUser,
									 [notice valueForKey:@"text"], KeyText,
									 nil];
						}
					}
				}
			}
			if (reply)
			{
				inReplyUser = [reply valueForKey:KeyUser];
				comment = [NSString stringWithFormat:@"(on %@: %@)",
						   [reply valueForKey:KeyUser], [reply valueForKey:KeyText]];
				if ((kind == kindTimeline) || (kind == kindChannel))
				{
					if ([[reply valueForKey:KeyUser] isEqualToString:user_id])
					{
						notify = _notifyReply;
						first = NO;
					}
				}
			}
			else if ((kind == kindTimeline) || (kind == kindChannel))
			{
				if (([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@$", user_id]] > 0) ||
					([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@[^!-~]", user_id]] > 0))
				{
					notify = _notifyReply;
					first = NO;
				}
			}
		}
		if (kind == kindTimeline)
		{
			NSDate *created_at = [[NSDate dateWithNaturalLanguageString:date] retain];
			int i = 0;
			while (i < [_since count])
			{
				NSDate *since = [_since objectAtIndex:i];
				if ([since compare:created_at] != NSOrderedDescending)
				{
					break;
				}
				i++;
			}
			[_since insertObject:created_at atIndex:i];
		}
		if (kind == kindDM)
		{
			item_id = [NSString stringWithFormat:@"DM%@", item_id];
			user_profile = [NSString stringWithFormat:@"%@ %@", user_profile, Mail];
		}
		NSString *rid = [obj valueForKey:@"rid"];
		item = [self createItem:item_id
					   withUser:screen_name
						   name:name
						channel:channel
							rid:rid
						   text:text
						comment:comment
						 source:[obj valueForKey:@"source"]
					 created_at:[NSDate dateWithNaturalLanguageString:date]
				   user_profile:user_profile
						 notify:notify
						   kind:kindStr
					inReplyUser:inReplyUser
						  first:first];
		//LOG(@"[%@(%@) parse:%d]\n%@", [self className], _service, kind, item);
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) parse:%d] EXCEPTION\n%@: %@", [self className], _service, kind, [exception name], [exception reason]);
	}
	return item;
}

- (void)retrieveTimeline
{
	//LOG(@"[%@(%@) retrieveTimeline]", [self className], _service);
	@synchronized(self)
	{
		if (_dateTimeline)
		{
			[self setupRetrieveDateTimeline:nil];
			@try
			{
				_xmppCount = 0;
				NSString *user = [_preferences accountIdenticaUser];
				NSString *pass = [_preferences accountIdenticaPass];
				NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:
									 @"identi.ca", TwitterHost,
									 @"http://identi.ca/api/statuses", TwitterURL,
									 user, TwitterUser,
									 pass, TwitterPass,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performRetrieveTimeline:)
										 toTarget:self
									   withObject:dic];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) retrieveTimeline] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
			}
		}
	}
}

- (void)retrieveReplies
{
	//LOG(@"[%@(%@) retrieveTimeline]", [self className], _service);
	@synchronized(self)
	{
		if (_dateReplies)
		{
			[self setupRetrieveDateReplies:nil];
			@try
			{
				NSString *user = [_preferences accountIdenticaUser];
				NSString *pass = [_preferences accountIdenticaPass];
				NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:
									 @"identi.ca", TwitterHost,
									 @"http://identi.ca/api/statuses", TwitterURL,
									 user, TwitterUser,
									 pass, TwitterPass,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performRetrieveReplies:)
										 toTarget:self
									   withObject:dic];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) retrieveReplies] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
			}
		}
	}
}

- (void)retrieveDirectMessage
{
	//LOG(@"[%@(%@) retrieveDirectMessage]", [self className], _service);
	@synchronized(self)
	{
		if (_dateDM)
		{
			[self setupRetrieveDateDM:nil];
			@try
			{
				NSString *user = [_preferences accountIdenticaUser];
				NSString *pass = [_preferences accountIdenticaPass];
				NSDictionary *dic = [[NSDictionary alloc] initWithObjectsAndKeys:
									 @"identi.ca", TwitterHost,
									 @"http://identi.ca/api", TwitterURL,
									 user, TwitterUser,
									 pass, TwitterPass,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performRetrieveDirectMessage:)
										 toTarget:self
									   withObject:dic];
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) retrieveDirectMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
			}
		}
	}
}

- (void)doReply:(NSString *)item_id
	   withText:(BOOL)withText
{
	@try
	{
		//LOG(@"[%@(%@) doReply]\n%@", [self className], _service, item_id);
		id obj = [self fetchALL:item_id withService:_service];
		if (obj)
		{
			if (![[obj valueForKey:KeyKind] isEqualToString:KindDM])
			{
				NSString *text = @"";
				if (withText)
				{
					text = [NSString stringWithFormat:@"@%@",
							[obj valueForKey:KeyUser]];
				}
				[_controller setReply:[self replyAttributedString:[NSString stringWithFormat:@"Reply to: %@%@",
															  [obj valueForKey:KeyText], [obj valueForKey:KeyComment]]]
						  withService:_service
							inReplyTo:item_id
								 text:text];
			}
			else
			{
				NSString *text = @"";
				if (withText)
				{
					text = [NSString stringWithFormat:@"d %@",
							[obj valueForKey:KeyUser]];
				}
				[_controller setReply:[self replyAttributedString:[NSString stringWithFormat:@"Reply DM: %@%@",
															  [obj valueForKey:KeyText], [obj valueForKey:KeyComment]]]
						  withService:_service
							inReplyTo:item_id
								 text:text];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) doReply] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
}

- (void)favorite:(NSString *)item_id
{
	//LOG(@"[%@(%@) favorite]", [self className], _service);
	@synchronized(self)
	{
		@try
		{
			id obj = [self fetchALL:item_id withService:_service];
			if (obj && ![[obj valueForKey:KeyKind] isEqualToString:KindDM])
			{
				NSString *user = [_preferences accountIdenticaUser];
				NSString *pass = [_preferences accountIdenticaPass];
				NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:
									 @"identi.ca", TwitterHost,
									 @"http://identi.ca/api", TwitterURL,
									 user, TwitterUser,
									 pass, TwitterPass,
									 nil];
				[NSThread detachNewThreadSelector:@selector(performFavorite:)
										 toTarget:self
									   withObject:[[NSArray alloc] initWithObjects:item_id, dic, nil]];
			}
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@(%@) favorite] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
		}
	}
}

- (void)permalink:(NSString *)item_id
{
	@try
	{
		id item = [self fetchALL:item_id withService:_service];
		if (item)
		{
			if ([[item valueForKey:KeyKind] isEqualToString:KindDM])
			{
				NSString *user = [_preferences accountIdenticaUser];
				[self doOpenURL:[NSString stringWithFormat:@"http://identi.ca/%@/inbox", user]];
			}
			else
			{
				[self doOpenURL:[NSString stringWithFormat:@"http://identi.ca/notice/%@", item_id]];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) permalink] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
}

- (void)doDirectMessage:(NSString *)item_id
{
	@try
	{
		//LOG(@"[%@(%@) doDirectMessage]\n%@", [self className], _service, item_id);
		id obj = [self fetchALL:item_id withService:_service];
		if (obj)
		{
			NSString *text = @"";
			text = [NSString stringWithFormat:@"d %@",
					[obj valueForKey:KeyUser]];
			[_controller setReply:[self replyAttributedString:[NSString stringWithFormat:@"DM: %@%@",
															   [obj valueForKey:KeyText], [obj valueForKey:KeyComment]]]
					  withService:_service
						inReplyTo:item_id
							 text:text];
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) doDirectMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
}

- (void)performReceiveMessage:(NSXMLElement *)message
{
	@try
	{
		//LOG(@"[%@(%@) performReceiveMessage]", [self className], _service);
		//LOG(@"[%@(%@) performReceiveMessage]\n%@", [self className], _service, message);
		BOOL valid = YES;
		NSXMLElement *x = [message elementForName:@"x" xmlns:@"jabber:x:delay"];
		if (x)
		{
			//LOG(@"[%@(%@) performReceiveMessage]\nx = %@", [self className], _service, x);
			NSString *stamp = [[x attributeForName:@"stamp"] stringValue];
			if (stamp)
			{
				//LOG(@"[%@(%@) performReceiveMessage]\nstamp = %@", [self className], _service, stamp);
				if (![_preferences accountIdenticaOfflineXMPP])
				{
					valid = NO;
				}
			}
		}
		if (valid)
		{
			BOOL doRetrieve = NO;
			[self lockService];
			@try
			{
				LOG(@"[%@(%@) performReceiveMessage]\nmessage = %@", [self className], _service, message);
				NSString *body = [[message elementForName:@"body"] stringValue];
				NSString *name = nil;
				NSString *icon = nil;
				NSString *xmpp_id = nil;
				NSString *published = nil;
				NSXMLElement *entry = [message elementForName:@"entry"];
				if (entry)
				{
					NSXMLElement *source = [entry elementForName:@"source"];
					if (source)
					{
						NSXMLElement *author = [source elementForName:@"author"];
						if (author)
						{
							name = [[author elementForName:@"name"] stringValue];
						}
						icon = [[source elementForName:@"icon"] stringValue];
					}
					xmpp_id = [[entry elementForName:@"id"] stringValue];
					published = [[entry elementForName:@"published"] stringValue];
				}
				if (body && name && icon && xmpp_id && published)
				{
					//LOG(@"[%@(%@) performReceiveMessage]\nname = %@", [self className], _service, name);
					//LOG(@"[%@(%@) performReceiveMessage]\nicon = %@", [self className], _service, icon);
					//LOG(@"[%@(%@) performReceiveMessage]\nid   = %@", [self className], _service, xmpp_id);
					//LOG(@"[%@(%@) performReceiveMessage]\npub  = %@", [self className], _service, published);
					if ([icon isEqualToString:@"http://identi.ca/theme/stoica/default-avatar-profile.png"])
					{
						icon = @"http://theme.identi.ca/identica/default-avatar-stream.png";
					}
					NSString *item_id = [xmpp_id replaceWithExpression:@".*/([0-9]+)$" replace:@"\\1"];
					NSString *exp = [NSString stringWithFormat:@"^%@: (.*)$", [name regularizeString]];
					NSString *text = [body replaceWithExpression:exp
														 replace:@"\\1"
														 options:OgreMultilineOption];
					NSString *date = [published replaceWithExpression:@"^(.*?)T(.*)\\+(.*):(.*)$"
															  replace:@"\\1 \\2 +\\3\\4"];
					NSDate *created_at = [NSDate dateWithNaturalLanguageString:date];
					NSString *channel = [self stringChannel:text];
					NSString *notify = _notify;
					//LOG(@"[%@(%@) performReceiveMessage]\nexp  = %@", [self className], _service, exp);
					//LOG(@"[%@(%@) performReceiveMessage]\nid   = %@", [self className], _service, item_id);
					//LOG(@"[%@(%@) performReceiveMessage]\ntext = %@", [self className], _service, text);
					//LOG(@"[%@(%@) performReceiveMessage]\ndate   = %@", [self className], _service, date);
					//LOG(@"[%@(%@) performReceiveMessage]\nat   = %@", [self className], _service, created_at);
					NSString *user_id = [_preferences accountIdenticaUser];
					if (![name isEqualToString:user_id] && [self hasKeyword:text])
					{
						notify = GrowlAfficheurKeywordsNotify;
					}
					if (channel)
					{
						notify = GrowlAfficheurIdenticaGroupNotify;
						channel = [NSString stringWithFormat:@" %@", channel];
					}
					else
					{
						channel = @"";
					}
					if (([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@$", user_id]] > 0) ||
						([text lengthOfRegularExpression:[NSString stringWithFormat:@"@%@[^!-~]", user_id]] > 0))
					{
						notify = _notifyReply;
					}
					text = [text replaceWithExpression:@"\\r" replace:@""];
					NSDictionary *item = [self createItem:item_id
												 withUser:name
													 name:@""
												  channel:channel
													  rid:@""
													 text:text
												  comment:@""
												   source:IM
											   created_at:created_at
											 user_profile:icon
												   notify:notify
													 kind:KindTimeline
											  inReplyUser:@""
													first:NO
													 xmpp:YES];
					if (item)
					{
						[item retain];
						NSMutableArray *list = [[NSMutableArray alloc] init];
						NSMutableArray *notify = [[NSMutableArray alloc] init];
						@try
						{
							if ([self addTimeline:item])
							{
								//LOG(@"[%@(%@) performReceiveMessage]\nnotify = %@", [self className], _service, [item valueForKey:KeyId]);
								if (![channel isEqualToString:@""])
								{
									[self registCompleteIdentica:channel];
								}
								[self registCompleteIdentica:text];
								[notify insertObject:item atIndex:0];
								_xmppCount++;
							}
							[list addObject:item];
							[self finishAddTimeline:list withNotify:notify];
							int retrieveCount = [_preferences accountIdenticaRetrieveXMPP];
							//LOG(@"[%@(%@) performReceiveMessage]\nretrieve = %d", [self className], _service, retrieve);
							if (retrieveCount > 0)
							{
								if (_xmppCount >= retrieveCount)
								{
									LOG(@"[%@(%@) performReceiveMessage] retrieve", [self className], _service);
									_xmppCount = 0;
									doRetrieve = YES;
									//[self retrieveTimeline];
								}
							}
							else
							{
								_xmppCount = 0;
							}
						}
						@catch (NSException *exception)
						{
							EXPLOG(@"[%@(%@) performReceiveMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
						}
						@finally
						{
							[notify release];
							[list release];
							[item release];
						}
					}
				}
			}
			@catch (NSException *exception)
			{
				EXPLOG(@"[%@(%@) performReceiveMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
			}
			@finally
			{
				[self unlockService];
			}
			if (doRetrieve)
			{
				LOG(@"[%@(%@) performReceiveMessage] doRetrieve", [self className], _service);
				[self retrieveTimeline];
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) performReceiveMessage] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
}

@end
