//
//  ServiceTumblr.m
//  Afficheur
//
//  Created by kichi on 08/09/02.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "ServiceTumblr.h"
#import "AfficheurController.h"
#import "AfficheurPreferences.h"
#import "TumblrAPI.h"
#import "NSStringOgreKit.h"
#import <OgreKit/OgreKit.h>


@implementation ServiceTumblr

- (id)init
{
	self = [super init];
	if (self)
	{
		_title = nil;
	}
	return self;
}


- (void)dealloc
{
	[_title release];
	[super dealloc];
}

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences
{
	self = [super init:service
		WithController:controller
		   preferences:preferences];
	if (self)
	{
	}
	return self;
}

- (NSString *)determinePost:(id)object
					withAPI:(TumblrAPI *)api
{
	id description = @"Post was failuer.";
	@try
	{
		//LOG(@"[%@(%@) determinPost] %@", [self className], _service, [api className]);
		if ([object isKindOfClass:[NSError class]])
		{
			NSString *desc = [api errorLocalizedDescription:object];
			if (desc)
			{
				description = [NSString stringWithFormat:@"%@\n(%@)", description, desc];
			}
		}
		else
		{
			NSString *result = [NSString stringWithFormat:@"%@", object];
			if ([result lengthOfRegularExpression:@"^[0-9]+$" withOptions:OgreIgnoreCaseOption])
			{
				description = nil;
			}
			else
			{
				NSString *title = [api titleOfHTML:result];
				if (title)
				{
					description = [NSString stringWithFormat:@"%@\n(%@)", description, title];
				}
				else
				{
					description = [NSString stringWithFormat:@"%@\n(%@)", description, object];
				}
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@(%@) determinPost] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
	}
	return description;
}

- (void)performPost:(NSArray *)array
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	@try
	{
		NSString *status = [array objectAtIndex:0];
		if ([_controller isURL:status])
		{
			NSString *url = nil;
			NSString *title = nil;
			@synchronized([NSApplication sharedApplication])
			{
				OGRegularExpression *regex = [OGRegularExpression
											  regularExpressionWithString:@"((?:http|https)://\\S+)"
											  options:OgreIgnoreCaseOption | OgreMultilineOption];
				// マッチ結果の列挙子の生成
				OGRegularExpressionMatch *match = [regex matchInString:status];
				NSString *substr = [match matchedString];
				if (substr)
				{
					url = substr;
				}
				regex = [OGRegularExpression
						 regularExpressionWithString:@"^(.*)\\s+(?:http|https)://"
						 options:OgreIgnoreCaseOption | OgreMultilineOption];
				// マッチ結果の列挙子の生成
				match = [regex matchInString:status];
				title = [match substringAtIndex:1];
			}
			if (url && title)
			{
				TumblrAPI* api = [[[TumblrAPI alloc] initWithDictionary:[array objectAtIndex:1]] autorelease];
				if (api)
				{
					id result = [api createLink:url title:title];
					[self determinePost:[self determinePost:result withAPI:api]
							  withTitle:_title
							   function:@"Post"];
				}
			}
		}
	}
	@catch (NSException *exception)
	{
		EXPLOG(@"[%@ performPost] EXCEPTION\n%@: %@", [self className], [exception name], [exception reason]);
	}
	@finally
	{
		[array release];
	}
	[pool release];
	[NSThread exit];
}

- (void)post:(NSString *)status
{
	@synchronized(self)
	{
		@try
		{
			NSString *user = [_preferences accountTumblrUser];
			NSString *pass = [_preferences accountTumblrPass];
			NSDictionary *dic = [NSDictionary dictionaryWithObjectsAndKeys:
								 user, TumblrUser,
								 pass, TumblrPass,
								 Afficheur, TumblrGenerator,
								 nil];
			[NSThread detachNewThreadSelector:@selector(performPost:)
									 toTarget:self
								   withObject:[[NSArray alloc] initWithObjects:status, dic, nil]];
		}
		@catch (NSException *exception)
		{
			EXPLOG(@"[%@(%@) post] EXCEPTION\n%@: %@", [self className], _service, [exception name], [exception reason]);
		}
	}
}

@end
