//
//  ServiceXMPPclient.h
//  Afficheur
//
//  Created by kichi on 08/11/15.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XMPPStream.h"

@interface ServiceXMPPClient : NSObject {
	id						_delegate;
	XMPPStream*				_xmpp;
	
	NSString*				_jid;
	NSString*				_pass;
	NSString*				_server;
	NSString*				_resource;
	int						_port;
	BOOL					_offline;
	BOOL					_connecting;
	BOOL					_authenticating;

	NSDate*					_keepDate;
}

- (ServiceXMPPClient *)initWithJid:(NSString *)jid
							  pass:(NSString *)pass
							server:(NSString *)server
							  port:(int)port
						   offline:(BOOL)offline
						  resource:(NSString *)resource;

- (ServiceXMPPClient *)initWithJid:(NSString *)jid
							  pass:(NSString *)pass
							server:(NSString *)server
							  port:(int)port
						   offline:(BOOL)offline;

- (void)setDelegate:(id)delegate;

- (XMPPStream *)xmpp;
- (NSString *)jid;
- (NSString *)pass;
- (NSString *)server;
- (int)port;

- (void)connect;
- (void)disconnect;
- (void)authenticate;
- (BOOL)diag;

- (void)keepConnection:(NSDate *)date;

- (void)post:(NSString *)msg
	 withJID:(NSString *)jid;

@end

@interface NSObject (ServiceXMPPClientDelegate)

- (void)serviceXMPPClient:(ServiceXMPPClient *)xc
		didReceiveMessage:(NSXMLElement *)message;

- (void)serviceXMPPClient:(XMPPStream *)xs
		  didReceiveError:(id)error;

@end
