//
//  TumblrAPI.m
//  Afficheur
//
//  Created by kichi on 08/04/07.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "TumblrAPI.h"
#import <JSON/JSON.h>
#import <OgreKit/OgreKit.h>

NSString *TumblrUser		= @"TumblrUser";
NSString *TumblrPass		= @"TumblrPass";
NSString *TumblrHost		= @"TumblrHost";
NSString *TumblrURL			= @"TumblrURL";
NSString *TumblrGenerator	= @"TumblrGenerator";

@implementation TumblrAPI

- (id)init
{
	self = [super init];
	if (self)
	{
		_keys = [[NSDictionary dictionaryWithObjectsAndKeys:
				  @"", TumblrUser,
				  @"", TumblrPass,
				  @"", TumblrHost,
				  @"", TumblrURL,
				  @"", TumblrGenerator,
				  nil] retain];
		_dic = [[NSMutableDictionary alloc] initWithObjectsAndKeys:
				@"", TumblrUser,
				@"", TumblrPass,
				@"www.Tumblr.com", TumblrHost,
				@"http://www.Tumblr.com/api", TumblrURL,
				nil];
	}
	return self;
}

- (void)dealloc
{
	[_dic release];
	[super dealloc];
}

- (id)initWithDictionary:(NSDictionary *)dic
{
	self = [self init];
	if (self)
	{
		NSEnumerator *enumerator = [dic keyEnumerator];
		id key;
		while ((key = [enumerator nextObject])) {
			id val = [_keys valueForKey:key];
			if (val == nil)
			{
				EXPLOG(@"[%@ initWithDictionary] NoKey: %@", [self className], key);
			}
			else
			{
				[_dic setValue:[dic valueForKey:key] forKey:key];
			}
		}
	}
	return self;
}


- (id)postWithAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body
{
	NSString *generator = @"";
	if ([_dic valueForKey:TumblrGenerator])
	{
		generator = [NSString stringWithFormat:@"&generator=%@", [_dic valueForKey:TumblrGenerator]];
	}
	NSString *auth = [HTTP base64String:
					  [NSString stringWithFormat:@"%@:%@",
					   [_dic valueForKey:TumblrUser],
					   [_dic valueForKey:TumblrPass]]];
	[header setValue:[_dic valueForKey:TumblrHost] forKey:@"Host"];
	[header setValue:[NSString stringWithFormat:@"Basic %@", auth] forKey:@"Authorization"];
	return [self post:[NSString stringWithFormat:@"%@/%@", [_dic valueForKey:TumblrURL], path]
			   header:header
				 body:[NSString stringWithFormat:@"email=%@&password=%@&%@%@",
					   [HTTP urlEncode:[_dic valueForKey:TumblrUser]
							 unescaped:nil
							   escaped:@"+"],
					   [HTTP urlEncode:[_dic valueForKey:TumblrPass]
							 unescaped:nil
							   escaped:@"+"],
					   body,
					   generator]];
}

- (id)createLink:(NSString *)link
		   title:(NSString *)title
{
	NSString *name = @"";
	if (title && ![title isEqualToString:@""])
	{
			name = [NSString stringWithFormat:@"&name=%@", [HTTP urlEncode:title
																 unescaped:nil
																   escaped:@"+"]];
	}
	id result = [self postWithAuth:@"write"
							header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									 @"application/x-www-form-urlencoded",
									 @"Content-Type",
									 nil] autorelease]
							  body:[NSString stringWithFormat:@"type=link&url=%@%@",
									[HTTP urlEncode:link
										  unescaped:nil
											escaped:@"+"],
									name]];
	return [self determineError:result WithJSON:NO];
}

@end
