//
//  TwitterAPI.h
//  Afficheur
//
//  Created by kichi on 08/04/05.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OAuth.h"


@interface TwitterAPI : OAuth {
	NSDictionary		*_keys;
	NSMutableDictionary	*_dic;
}

- (id)init;
- (id)initWithDictionary:(NSDictionary *)dic;

- (NSString *)user;

- (id)postWithAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body;

- (id)getWithAuth:(NSString *)path
		   header:(NSMutableDictionary *)header
			 body:(NSString *)body;

- (id)update:(NSString *)status;
- (id)update:(NSString *)status
   withReply:(NSString *)reply;

//- (id)updateNowa:(NSString *)status
//	   withReply:(NSString *)reply;

- (id)performRetrieve:(NSString *)path
			withSince:(NSString *)since;

- (id)headHost;

- (id)friendsTimeline;
- (id)friendsTimelineWithSince:(NSString *)since;
- (id)friendsTimelineWithSince:(NSString *)since
						tweets:(int)tweets;
- (id)replies;
- (id)repliesWithSince:(NSString *)since;
- (id)replies;
- (id)repliesWithSince:(NSString *)since;
- (id)directMessage;
- (id)directMessageWithSince:(NSString *)since;

- (id)favorite:(NSString *)item_id;

- (id)show:(NSString *)item_id;
- (id)showWithoutAuth:(NSString *)item_id;

- (id)rateLimit;

@end

APPKIT_EXTERN NSString *TwitterUser;
APPKIT_EXTERN NSString *TwitterPass;
APPKIT_EXTERN NSString *TwitterHost;
APPKIT_EXTERN NSString *TwitterURL;
APPKIT_EXTERN NSString *TwitterSource;
APPKIT_EXTERN NSString *TwitterUpdate;
APPKIT_EXTERN NSString *TwitterKey;
APPKIT_EXTERN NSString *TwitterSecret;
