//
//  TwitterAPI.m
//  Afficheur
//
//  Created by kichi on 08/04/05.
//  Copyright 2008 Katsuhiko Ichinose. All rights reserved.
//

#import "TwitterAPI.h"
#import "NSStringOgreKit.h"
#import <OgreKit/OgreKit.h>

NSString *TwitterUser	= @"TwitterUser";
NSString *TwitterPass	= @"TwitterPass";
NSString *TwitterHost	= @"TwitterHost";
NSString *TwitterURL	= @"TwitterURL";
NSString *TwitterSource	= @"TwitterSource";
NSString *TwitterUpdate	= @"TwitterUpdate";
NSString *TwitterKey	= @"TwitterKey";
NSString *TwitterSecret	= @"TwitterSecret";

@implementation TwitterAPI

- (id)init
{
	self = [super init];
	if (self)
	{
		_keys = [[NSDictionary dictionaryWithObjectsAndKeys:
				  @"", TwitterUser,
				  @"", TwitterPass,
				  @"", TwitterKey,
				  @"", TwitterSecret,
				  @"", TwitterHost,
				  @"", TwitterURL,
				  @"", TwitterSource,
				  @"", TwitterUpdate,
				  nil] retain];
		_dic = [[NSMutableDictionary alloc] initWithObjectsAndKeys:
				@"status", TwitterUpdate,
				@"", TwitterUser,
				@"", TwitterPass,
				@"", TwitterKey,
				@"", TwitterSecret,
				@"twitter.com", TwitterHost,
				@"http://twitter.com/statuses", TwitterURL,
				nil];
	}
	return self;
}

- (void)dealloc
{
	[_keys release];
	[_dic release];
	[super dealloc];
}

- (id)initWithDictionary:(NSDictionary *)dic
{
	self = [self init];
	if (self)
	{
		NSEnumerator *enumerator = [dic keyEnumerator];
		id key;
		while ((key = [enumerator nextObject])) {
			id val = [_keys valueForKey:key];
			if (val == nil)
			{
				EXPLOG(@"[%@ initWithDictionary] NoKey: %@", [self className], key);
			}
			else
			{
				id value = [dic valueForKey:key];
				if (![value isKindOfClass:[NSNull class]])
				{
					[_dic setValue:value forKey:key];
					if ([key isEqualToString:TwitterKey])
					{
						[self setAccessToken:value];
					}
					else if ([key isEqualToString:TwitterSecret])
					{
						[self setAccessTokenSecret:value];
					}
				}
				else
				{
					[_dic removeObjectForKey:key];
					if ([key isEqualToString:TwitterKey])
					{
						[self setAccessToken:nil];
					}
					else if ([key isEqualToString:TwitterSecret])
					{
						[self setAccessTokenSecret:nil];
					}
				}
			}
		}
	}
	return self;
}

- (NSString *)user
{
	return [_dic valueForKey:TwitterUser];
}

- (id)postWithAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body
{
	NSString* src = @"";
	if ([_dic valueForKey:TwitterSource])
	{
		src = [NSString stringWithFormat:@"&source=%@", [_dic valueForKey:TwitterSource]];
	}
	NSString *auth = [HTTP base64String:
					  [NSString stringWithFormat:@"%@:%@",
					   [_dic valueForKey:TwitterUser],
					   [_dic valueForKey:TwitterPass]]];
	[header setValue:[_dic valueForKey:TwitterHost] forKey:@"Host"];
	[header setValue:[NSString stringWithFormat:@"Basic %@", auth] forKey:@"Authorization"];
	return [self post:[NSString stringWithFormat:@"%@/%@", [_dic valueForKey:TwitterURL], path]
			   header:header
				 body:[NSString stringWithFormat:@"%@%@", body, src]];
}

- (id)getWithAuth:(NSString *)path
		   header:(NSMutableDictionary *)header
			 body:(NSString *)body
{
	NSString *auth = [HTTP base64String:
					  [NSString stringWithFormat:@"%@:%@",
					   [_dic valueForKey:TwitterUser],
					   [_dic valueForKey:TwitterPass]]];
	[header setValue:[_dic valueForKey:TwitterHost] forKey:@"Host"];
	[header setValue:[NSString stringWithFormat:@"Basic %@", auth] forKey:@"Authorization"];
	return [self get:path header:header body:body];
}

- (id)headWithAuth:(NSString *)path
			header:(NSMutableDictionary *)header
			  body:(NSString *)body
{
	NSString *auth = [HTTP base64String:
					  [NSString stringWithFormat:@"%@:%@",
					   [_dic valueForKey:TwitterUser],
					   [_dic valueForKey:TwitterPass]]];
	[header setValue:[_dic valueForKey:TwitterHost] forKey:@"Host"];
	[header setValue:[NSString stringWithFormat:@"Basic %@", auth] forKey:@"Authorization"];
	return [self head:path header:header body:body];
}

- (id)update:(NSString *)status
{
	return [self update:status withReply:@""];
}

- (id)update:(NSString *)status
   withReply:(NSString *)reply
{
	id result = nil;
	if (_access_token && _access_token_secret)
	{
		result = [self postWithOAuth:[NSString stringWithFormat:@"%@/update.json", [_dic valueForKey:TwitterURL]]
							  header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									   @"application/x-www-form-urlencoded", @"Content-Type",
									   nil]
									  autorelease]
								body:[NSString stringWithFormat:@"%@=%@%@", 
									  [_dic valueForKey:TwitterUpdate],
									  [HTTP urlEncode:status
											unescaped:@"-._~"
											  escaped:@" !@#$^&*()`+=[]{}\\|;:'\"<>?,/"/*@"&+=;?"*/],
									  reply]];
		LOG(@"[%@ update]\n%@", [self className], [[[NSString alloc] initWithData:result encoding:NSUTF8StringEncoding] autorelease]);
	}
	else
	{
		result = [self postWithAuth:@"update.json"
							 header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									  @"application/x-www-form-urlencoded",
									  @"Content-Type",
									  nil]
									 autorelease]
							   body:[NSString stringWithFormat:@"%@=%@%@", 
									 [_dic valueForKey:TwitterUpdate],
									 [HTTP urlEncode:status
										   unescaped:nil
											 escaped:@"&+=;"],
									 reply]];
	}
	return [self determineError:result WithJSON:YES];
}

#if 0
- (id)updateNowa:(NSString *)status
	   withReply:(NSString *)reply
{
	id result = [self postWithAuth:@"update.json"
							header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									 @"application/x-www-form-urlencoded",
									 @"Content-Type",
									 nil]
									autorelease]
							  body:[NSString stringWithFormat:@"%@=%@%@", 
									[_dic valueForKey:TwitterUpdate],
									[HTTP urlEncode:status
										  unescaped:nil
											escaped:@"&+;"],
									reply]];
	if ([result isKindOfClass:[NSData class]])
	{
		NSString* data = [[[NSString alloc] initWithData:result
												encoding:NSUTF8StringEncoding] autorelease];
		//LOG(@"[%@ update]\n%@", [self className], result);
		//LOG(@"[%@ update]\n%@", [self className], data);
		unichar unicode = [data characterAtIndex:0];
		if (![[NSString stringWithCharacters:&unicode
									  length:1] isEqualToString:@"{"])
		{
			data = [data replaceWithExpression:@"\r\n"
									   replace:@"\n"];
			//options:OgreMultilineOption];
			data = [data replaceWithExpression:@"^.*?\n\n(.*)$"
									   replace:@"\\1"
									   options:OgreMultilineOption];
			const char* utf8 = [data UTF8String];
			result = [NSData dataWithBytes:utf8 length:strlen(utf8)];
			//LOG(@"[%@ update]\n%@", [self className], data);
			//LOG(@"[%@ update]\n%@", [self className], result);
		}
	}
	return [self determineError:result WithJSON:YES];
}
#endif

- (id)performRetrieve:(NSString *)path
			withSince:(NSString *)since
			   tweets:(int)tweets
{
	//LOG(@"[%@ performRetrieve]\n%@\n%@", [self className], path, _dic);
	NSMutableDictionary *header = [[[NSMutableDictionary alloc] initWithObjectsAndKeys:
								//	@"text/javascript", //@"application/x-www-form-urlencoded",
								//	@"Content-Type",
								//	@"Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.5; ja-JP-mac; rv:1.9.0.3) Gecko/2008092414 Firefox/3.0.3",
								/*	@"",
									@"User-Agent"
									@"text/html,application/xhtml+xml,application/xml,text/javascript,application/json",
									@"Accept",
									@"ja,en-us",
									@"Accept-Language",
									@"deflate",
									@"Accept-Encoding",
									@"utf-8",
									@"Accept-Charset",*/
									nil] autorelease];
	if (since)
	{
#if 1
#if 0
		NSString *join = @"?";
		if ([path lengthOfRegularExpression:@"\\?"] > 0)
		{
			join = @"&";
		}
		path = [NSString stringWithFormat:@"%@%@since_id=%@",
				path,
				join,
				since];
#endif
#else
		//?since=Tue%2C+27+Mar+2007+22%3A55%3A48+GMT
		NSDateFormatter *formatter = [[[NSDateFormatter alloc] init] autorelease];
		[formatter setFormatterBehavior:NSDateFormatterBehavior10_4];
		NSLocale *locale = [[[NSLocale alloc] initWithLocaleIdentifier:@"en_US"] autorelease];
		[formatter setLocale:locale];
		[formatter setTimeZone:[NSTimeZone timeZoneForSecondsFromGMT:0]];
		[formatter setDateFormat:@"EEE,+d+MMM+yyyy+HH:mm:ss"];
		NSString *join = @"?";
		if ([path lengthOfRegularExpression:@"\\?"] > 0)
		{
			join = @"&";
		}
		path = [NSString stringWithFormat:@"%@%@since=%@+GMT",
				path,
				join,
				[HTTP urlEncode:[formatter stringFromDate:since]
					  unescaped:nil
						escaped:@",:"]];
#endif
	}
	if (tweets > 20)
	{
		NSString *join = @"?";
		if ([path lengthOfRegularExpression:@"\\?"] > 0)
		{
			join = @"&";
		}
		path = [NSString stringWithFormat:@"%@%@count=%d",
				path,
				join,
				tweets];
		LOG(@"[%@ performRetrieve]\n%@", [self className], path);
	}
	id result = nil;
	if (_access_token && _access_token_secret)
	{
		result = [self getWithOAuth:path header:header body:@""];
	}
	else
	{
		result = [self getWithAuth:path header:header body:@""];
	}
	//LOG(@"[%@ performRetrieve] %d\n%@\n%@\n%@", [self className], _statusCode, path, header, result);
	return [self determineError:result WithJSON:YES];
}

- (id)performRetrieve:(NSString *)path
			withSince:(NSString *)since
{
	return [self performRetrieve:path
					   withSince:since
						  tweets:0];
}

- (id)performRetrieveWithoutAuth:(NSString *)path
{
	//LOG(@"[%@ performRetrieve]\n%@\n%@", [self className], path, _dic);
	NSMutableDictionary *header = [[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									nil] autorelease];
	id result = [self get:path header:header body:@""];
	//LOG(@"[%@ performRetrieve] %d\n%@\n%@\n%@", [self className], _statusCode, path, header, result);
	return [self determineError:result WithJSON:YES];
}

- (id)performHeadRetrieve:(NSString *)path
{
	//LOG(@"[%@ performRetrieve]\n%@\n%@", [self className], path, _dic);
	NSMutableDictionary *header = [[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									nil] autorelease];
	id result = [self head:path header:header body:@""];
	//LOG(@"[%@ performHeadRetrieve] %d\n%@\n%@\n%@", [self className], _statusCode, path, header, result);
	return result; //[self determineError:result WithJSON:NO];
}

- (id)headHost
{
	//LOG(@"[%@ headHost]", [self className]);
	return [self performHeadRetrieve:[NSString stringWithFormat:@"http://%@/",
									  [_dic valueForKey:TwitterHost]]];
}

- (id)friendsTimeline
{
//	return [self friendsTimelineWithSince:nil];
	id result = [self performRetrieve:[NSString stringWithFormat:@"%@/%@",
									   [_dic valueForKey:TwitterURL],
									   @"friends_timeline.json"]
							withSince:nil
							   tweets:0];
	return result;
}

- (id)friendsTimelineWithSince:(NSString *)since
{
	//	return [self friendsTimelineWithSince:since
	//								   tweets:0];
	id result = [self performRetrieve:[NSString stringWithFormat:@"%@/%@",
									   [_dic valueForKey:TwitterURL],
									   @"friends_timeline.json"]
							withSince:since
							   tweets:0];
	return result;
}

- (id)friendsTimelineWithSince:(NSString *)since
						tweets:(int)tweets
{
	//LOG(@"[%@ friendsTimelineWithSince]", [self className]);
	id result = [self performRetrieve:[NSString stringWithFormat:@"%@/%@",
									   [_dic valueForKey:TwitterURL],
									   @"friends_timeline.json"]
							withSince:since
							   tweets:tweets];
	LOG(@"[%@ friendsTimelineWithSince:tweets:]\n%@", [self className], [self headers]);
	return result;
}

- (id)replies
{
	return [self repliesWithSince:nil];
}

- (id)repliesWithSince:(NSString *)since;
{
	//LOG(@"[%@ repliesWithSince]", [self className]);
	return [self performRetrieve:[NSString stringWithFormat:@"%@/%@",
								  [_dic valueForKey:TwitterURL],
								  @"replies.json"]
					   withSince:since];
}

- (id)directMessage
{
	return [self directMessageWithSince:nil];
}

- (id)directMessageWithSince:(NSString *)since
{
	//LOG(@"[%@ directMessageWithSince]", [self className]);
	id result = [self performRetrieve:[NSString stringWithFormat:@"%@/%@",
									   [_dic valueForKey:TwitterURL],
									   @"direct_messages.json"]
							withSince:since];
	return result;
}

- (id)favorite:(NSString *)item_id
{
	id result = [self postWithAuth:[NSString stringWithFormat:@"/favorites/create/%@.json", item_id]
							header:[[[NSMutableDictionary alloc] initWithObjectsAndKeys:
									 @"application/x-www-form-urlencoded",
									 @"Content-Type",
									 nil] autorelease]
							  body:@""];
	return [self determineError:result WithJSON:YES];
}

- (id)show:(NSString *)item_id
{
	//LOG(@"[%@ show]", [self className]);
	id result = [self performRetrieve:[NSString stringWithFormat:@"%@/show/%@.json",
									   [_dic valueForKey:TwitterURL],
									   item_id]
							withSince:nil];
	return result;
}

- (id)showWithoutAuth:(NSString *)item_id
{
	//LOG(@"[%@ showWithoutAuth]", [self className]);
	id result = [self performRetrieveWithoutAuth:[NSString stringWithFormat:@"%@/show/%@.json",
									   [_dic valueForKey:TwitterURL],
									   item_id]];
	return result;
}

- (id)rateLimit
{
	//LOG(@"[%@ rateLimit]", [self className]);
	id result = [self performRetrieve:[NSString stringWithFormat:@"%@/%@",
									   [_dic valueForKey:TwitterURL],
									   @"account/rate_limit_status.json"]
							withSince:nil];
	return result;
}

@end
