//
//  FaceBookAPI.m
//  Afficheur
//
//  Created by kichi on 11/01/02.
//  Copyright 2011 Katsuhiko Ichinose. All rights reserved.
//

#import "FaceBookAPI.h"

NSString *FaceBookId		= @"FaceBookId";
NSString *FaceBookUser		= @"FaceBookUser";
NSString *FaceBookHost		= @"FaceBookHost";
NSString *FaceBookURL		= @"FaceBookURL";
NSString *FaceBookToken		= @"FaceBookToken";

@implementation FaceBookAPI

- (id)init
{
	self = [super init];
	if (self)
	{
		_keys = [[NSDictionary dictionaryWithObjectsAndKeys:
				  @"", FaceBookId,
				  @"", FaceBookUser,
				  @"", FaceBookHost,
				  @"", FaceBookURL,
				  @"", FaceBookToken,
				  nil] retain];
		_dic = [[NSMutableDictionary alloc] initWithObjectsAndKeys:
				@"", FaceBookId,
				@"", FaceBookUser,
				@"", FaceBookToken,
				@"graph.facebook.com", FaceBookHost,
				@"https://graph.facebook.com", FaceBookURL,
				nil];
	}
	return self;
}

- (void)dealloc
{
	[_keys release];
	[_dic release];
	[super dealloc];
}

- (id)initWithDictionary:(NSDictionary *)dic
{
	self = [self init];
	if (self)
	{
		NSEnumerator *enumerator = [dic keyEnumerator];
		id key;
		while ((key = [enumerator nextObject])) {
			id val = [_keys valueForKey:key];
			if (val == nil)
			{
				EXPLOG(@"[%@ initWithDictionary] NoKey: %@", [self className], key);
			}
			else
			{
				id value = [dic valueForKey:key];
				[_dic setValue:value forKey:key];
				if ([key isEqualToString:FaceBookToken])
				{
					[self setAccessToken:value];
				}
			}
		}
	}
	return self;
}

- (NSString *)accessToken
{
	return [[_access_token copy] autorelease];
}

- (void)setAccessToken:(NSString *)access_token
{
	if (_access_token)
	{
		[_access_token release];
	}
	if (access_token)
	{
		_access_token = [access_token copy];
	}
	else
	{
		_access_token = nil;
	}
}

- (NSString *)stringGraphURL:(NSString *)path
{
	return [NSString stringWithFormat:@"%@/%@",
			[_dic valueForKey:FaceBookURL],
			path
			];
}

- (id)postGraph:(NSString *)path
	   withBody:(NSString *)body
		   json:(BOOL)json
{
	LOG2(@"[%@ postGraph] %@", [self className], path);
	id result =[self post:[NSString stringWithFormat:@"%@?access_token=%@",
						   [self stringGraphURL:path],
						   [HTTP urlEncode:[_dic valueForKey:FaceBookToken]]]
				   header:[NSMutableDictionary dictionaryWithObjectsAndKeys:
						   [_dic valueForKey:FaceBookHost], @"Host",
						   nil]
					 body:[HTTP urlEncode:body]];
	return [self determineError:result WithJSON:json];
}

- (id)postGraph:(NSString *)path
	   withBody:(NSString *)body
{
	return [self postGraph:path withBody:body json:YES];
}

- (id)getGraph:(NSString *)path
{
	LOG2(@"[%@ getGraph] %@", [self className], path);
	id result =[self get:[NSString stringWithFormat:@"%@?access_token=%@",
						  [self stringGraphURL:path],
						  [HTTP urlEncode:[_dic valueForKey:FaceBookToken]]]
				  header:[NSMutableDictionary dictionaryWithObjectsAndKeys:
						  [_dic valueForKey:FaceBookHost], @"Host",
						  nil]
					body:@""];
	return [self determineError:result WithJSON:YES];
}

- (id)headGraph:(NSString *)path
{
	LOG2(@"[%@ headGraph] %@", [self className], path);
	id result =[self head:[NSString stringWithFormat:@"%@?access_token=%@",
						   [self stringGraphURL:path],
						   [HTTP urlEncode:[_dic valueForKey:FaceBookToken]]]
				   header:[NSMutableDictionary dictionaryWithObjectsAndKeys:
						   [_dic valueForKey:FaceBookHost], @"Host",
						   nil]
					 body:@""];
	return result;
}

- (id)postFeed:(NSString *)feed
{
	LOG(@"[%@ postFeed]", [self className]);
	return [self postGraph:@"me/feed"
				  withBody:[NSString stringWithFormat:
							@"message=%@&privacy={\"value\": \"ALL_FRIENDS\"}",
							feed]];
}

- (id)comment:(NSString *)comment
	   withId:(NSString *)commentId
{
	LOG(@"[%@ comment] %@", [self className], commentId);
	return [self postGraph:[NSString stringWithFormat:
							@"%@/comments",
							commentId]
				  withBody:[NSString stringWithFormat:
							@"message=%@&privacy={\"value\": \"ALL_FRIENDS\"}",
							comment]];
}

- (id)homeFeed
{
	return [self getGraph:@"me/home"];
}

- (id)headHomeFeed
{
	return [self headGraph:@"me/home"];
}


- (id)me
{
	return [self getGraph:@"me"];
}

- (NSString *)userId
{
	return [_dic valueForKey:FaceBookId];
}

- (id)likes:(NSString *)itemId
{
	LOG(@"[%@ likes] %@", [self className], commentId);
	return [self postGraph:[NSString stringWithFormat:
							@"%@/likes",
							itemId]
				  withBody:@""
					  json:NO];
}

@end
