//
//  ServiceFriendFeed.h
//  Afficheur
//
//  Created by kichi on 10/01/03.
//  Copyright 2010 Katsuhiko Ichinose. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Service.h"
#import "FriendFeedAPI.h"

@interface ServiceFriendFeed : Service {
	NSString*				_notify;
	NSString*				_notifyComment;
	NSString*				_notifyReply;
	NSString*				_notifyError;
	
	NSMutableDictionary*	_userProfile;
	NSDate*					_dateTimeline;
	
	BOOL					_first;
	
	NSString*				_request_token;
	NSString*				_request_token_secret;
	NSString*				_access_token;
	NSString*				_access_token_secret;
}

enum {
	kindHomeFeed = 0,
	kindComment,
};

- (id)init:(NSString *)service
WithController:(AfficheurController *)controller
preferences:(AfficheurPreferences *)preferences;

- (NSString *)authorize;
- (BOOL)access_token;
- (NSString *)accessToken;
- (NSString *)accessTokenSecret;

- (void)setupRetrieveDate:(NSDate *)date;
- (void)setupRetrieveDateTimeline:(NSDate *)date;

- (BOOL)checkRetrieveTimeline:(NSDate *)date;

- (void)post:(NSString *)status;
- (void)post:(NSString *)status
   withReply:(NSString *)item_id;

- (void)retrieveHomeFeed;

- (void)favorite:(NSString *)item_id;

- (NSString *)permalinkURL:(NSString *)item_id;
- (void)permalink:(NSString *)item_id;

@end
