//
//  FriendFeedAPI.h
//  Afficheur
//
//  Created by kichi on 10/01/03.
//  Copyright 2010 Katsuhiko Ichinose. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OAuth.h"


@interface FriendFeedAPI : OAuth {
	NSDictionary		*_keys;
	NSMutableDictionary	*_dic;
}

- (id)init;
- (id)initWithDictionary:(NSDictionary *)dic;


- (NSString *)user;

- (id)ia_access_token:(NSString *)url;

- (id)entry:(NSString *)status;
- (id)entry:(NSString *)status
		 to:(NSString *)group;
- (id)comment:(NSString *)comment
	  withID:(NSString *)entry_id;

- (id)like:(NSString *)entry_id;

- (id)homeFeed;
- (id)headHomeFeed;

@end

APPKIT_EXTERN NSString *FriendFeedUser;
APPKIT_EXTERN NSString *FriendFeedPass;
APPKIT_EXTERN NSString *FriendFeedHost;
APPKIT_EXTERN NSString *FriendFeedURL;
APPKIT_EXTERN NSString *FriendFeedKey;
APPKIT_EXTERN NSString *FriendFeedSecret;
